/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.client.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.function.Consumer;
import me.xjqsh.lrtactical.client.resource.display.MeleeDisplayInstance;
import me.xjqsh.lrtactical.client.resource.display.ThrowableDisplayInstance;
import me.xjqsh.lrtactical.client.resource.manager.MeleeDisplayManager;
import me.xjqsh.lrtactical.client.resource.manager.ThrowableDisplayManager;
import me.xjqsh.lrtactical.init.ModItems;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="lrtactical")
public enum LrClientAssetsManager {
    INSTANCE;

    public static final Gson GSON;
    private ThrowableDisplayManager throwableDisplay;
    private MeleeDisplayManager meleeDisplay;

    public void reloadAndRegister(Consumer<PreparableReloadListener> register) {
        this.throwableDisplay = new ThrowableDisplayManager(GSON);
        this.meleeDisplay = new MeleeDisplayManager(GSON);
        register.accept((PreparableReloadListener)this.throwableDisplay);
        register.accept((PreparableReloadListener)this.meleeDisplay);
    }

    public ThrowableDisplayInstance getThrowableDisplay(ResourceLocation id) {
        return (ThrowableDisplayInstance)this.throwableDisplay.getData(id);
    }

    public MeleeDisplayInstance getMeleeDisplay(ResourceLocation id) {
        return (MeleeDisplayInstance)this.meleeDisplay.getData(id);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onClientResourceReload(RegisterClientReloadListenersEvent event) {
        INSTANCE.reloadAndRegister(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0));
        event.registerReloadListener((PreparableReloadListener)IClientItemExtensions.of((Item)((Item)ModItems.FLASH_SHIELD.get())).getCustomRenderer());
    }

    static {
        GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).create();
    }
}

