/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.client.renderer.model;

import com.tacz.guns.client.model.BedrockAnimatedModel;
import com.tacz.guns.client.model.FunctionalBedrockPart;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.model.bedrock.ModelRendererWrapper;
import com.tacz.guns.client.model.functional.LeftHandRender;
import com.tacz.guns.client.model.functional.RightHandRender;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class CustomBedrockModel
extends BedrockAnimatedModel {
    private static final Pattern FIRSTPERSON_EFFECT_PATTERN = Pattern.compile("^1p_effect(_(\\d+))?$");
    private static final Pattern ENTITY_HIDE_PATTERN = Pattern.compile("^entity_hide(_(\\d+))?$");
    private boolean effectVisible = false;
    private boolean entityRendering = false;

    public CustomBedrockModel(BedrockModelPOJO pojo, BedrockVersion version) {
        super(pojo, version);
        this.setFunctionalRenderer("lefthand_pos", bedrockPart -> new LeftHandRender((BedrockAnimatedModel)this));
        this.setFunctionalRenderer("righthand_pos", bedrockPart -> new RightHandRender((BedrockAnimatedModel)this));
        for (Map.Entry entry : this.modelMap.entrySet()) {
            FunctionalBedrockPart functionalPart;
            BedrockPart bedrockPart2;
            if (FIRSTPERSON_EFFECT_PATTERN.matcher((CharSequence)entry.getKey()).find()) {
                bedrockPart2 = ((ModelRendererWrapper)entry.getValue()).getModelRenderer();
                if (!(bedrockPart2 instanceof FunctionalBedrockPart)) continue;
                functionalPart = (FunctionalBedrockPart)bedrockPart2;
                functionalPart.functionalRenderer = this::renderEffect;
                continue;
            }
            if (!ENTITY_HIDE_PATTERN.matcher((CharSequence)entry.getKey()).find() || !((bedrockPart2 = ((ModelRendererWrapper)entry.getValue()).getModelRenderer()) instanceof FunctionalBedrockPart)) continue;
            functionalPart = (FunctionalBedrockPart)bedrockPart2;
            functionalPart.functionalRenderer = this::renderEntityHide;
        }
    }

    @Nullable
    private IFunctionalRenderer renderEffect(BedrockPart part) {
        part.visible = this.effectVisible;
        return null;
    }

    @Nullable
    private IFunctionalRenderer renderEntityHide(BedrockPart part) {
        part.visible = !this.entityRendering;
        return null;
    }

    public void setEffectVisible(boolean visible) {
        this.effectVisible = visible;
    }

    public boolean isEffectVisible() {
        return this.effectVisible;
    }

    public void setEntityRendering(boolean entityRendering) {
        this.entityRendering = entityRendering;
    }

    public boolean isEntityRendering() {
        return this.entityRendering;
    }
}

