/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.api.animation;

import com.tacz.guns.client.animation.statemachine.ItemAnimationStateContext;
import java.util.Optional;
import java.util.function.Function;
import me.xjqsh.lrtactical.api.item.IThrowable;
import me.xjqsh.lrtactical.item.throwable.ThrowableData;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BaseAnimationStateContext
extends ItemAnimationStateContext {
    private ItemStack currentItem = ItemStack.f_41583_;
    private int usingTick = 0;
    private boolean using = false;
    private int prepareTime = 0;
    private float walkDistAnchor = 0.0f;

    public void setCurrentItem(ItemStack currentItem) {
        this.currentItem = currentItem;
        Item item = currentItem.m_41720_();
        if (item instanceof IThrowable) {
            IThrowable iThrowable = (IThrowable)item;
            this.prepareTime = iThrowable.getThrowableIndex(currentItem).map(index -> ((ThrowableData)index.getData()).getPrepareTime()).orElse(0);
        }
    }

    private <T> Optional<T> processCameraEntity(Function<Entity, T> processor) {
        Entity entity = Minecraft.m_91087_().f_91075_;
        if (entity != null) {
            return Optional.ofNullable(processor.apply(entity));
        }
        return Optional.empty();
    }

    public long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public boolean isInputUp() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91074_).map(player -> player.f_108618_.f_108568_).orElse(false);
    }

    public boolean isInputDown() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91074_).map(player -> player.f_108618_.f_108569_).orElse(false);
    }

    public boolean isInputLeft() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91074_).map(player -> player.f_108618_.f_108570_).orElse(false);
    }

    public boolean isInputRight() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91074_).map(player -> player.f_108618_.f_108571_).orElse(false);
    }

    public boolean isInputJumping() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91074_).map(player -> player.f_108618_.f_108572_).orElse(false);
    }

    public boolean isOnGround() {
        return this.processCameraEntity(Entity::m_20096_).orElse(false);
    }

    public boolean isCrouching() {
        return this.processCameraEntity(Entity::m_6047_).orElse(false);
    }

    public void anchorWalkDist() {
        this.processCameraEntity(entity -> {
            this.walkDistAnchor = entity.f_19787_ + (entity.f_19787_ - entity.f_19867_) * this.partialTicks;
            return null;
        });
    }

    public float getWalkDist() {
        return this.processCameraEntity(entity -> {
            float currentWalkDist = entity.f_19787_ + (entity.f_19787_ - entity.f_19867_) * this.partialTicks;
            return Float.valueOf(currentWalkDist - this.walkDistAnchor);
        }).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

