/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.common.network.packet;

import com.lazrproductions.lazrslib.common.network.LazrNetworkedParameterHandler;
import com.lazrproductions.lazrslib.common.network.base.ILazrPacket;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public abstract class ParameterizedLazrPacket
implements ILazrPacket {
    Object[] parameters;

    public ParameterizedLazrPacket(FriendlyByteBuf buffer) {
        LazrNetworkedParameterHandler.readPacket(this, buffer);
    }

    public ParameterizedLazrPacket(Object ... p) {
        this.parameters = p;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        LazrNetworkedParameterHandler.writePacketParameters(this.parameters, buffer);
    }

    public void setFrom(Object[] parameters) {
        this.parameters = parameters;
        this.loadValues(parameters);
    }

    public abstract void loadValues(Object[] var1);

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            NetworkDirection dir = ctx.getDirection();
            if (dir == NetworkDirection.PLAY_TO_SERVER || dir == NetworkDirection.LOGIN_TO_SERVER) {
                this.handleServerside(context);
            } else {
                this.handleClientside(context);
            }
        });
        ctx.setPacketHandled(true);
    }

    public abstract void handleClientside(Supplier<NetworkEvent.Context> var1);

    public abstract void handleServerside(Supplier<NetworkEvent.Context> var1);
}

