/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.client.screen.base;

import com.lazrproductions.lazrslib.client.screen.base.ScreenRect;

public class BlitCoordinates {
    private int x;
    private int y;
    private int width;
    private int height;
    private Alignment alignment;
    public static final BlitCoordinates DEFAULT = new BlitCoordinates(0, 0, 1, 1);

    public BlitCoordinates(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.alignment = Alignment.DEFAULT;
    }

    public int getX() {
        switch (this.alignment) {
            case CENTER: {
                return this.x + this.width / 2;
            }
        }
        return this.x;
    }

    public int getY() {
        switch (this.alignment) {
            case CENTER: {
                return this.y + this.height / 2;
            }
        }
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BlitCoordinates move(int offsetX, int offsetY) {
        return new BlitCoordinates(this.getX() + offsetX, this.getY() + offsetY, this.getWidth(), this.getHeight());
    }

    public BlitCoordinates withX(int value) {
        this.x = value;
        return this;
    }

    public BlitCoordinates withY(int value) {
        this.y = value;
        return this;
    }

    public BlitCoordinates withWidth(int value) {
        this.width = value;
        return this;
    }

    public BlitCoordinates withHeight(int value) {
        this.height = value;
        return this;
    }

    public ScreenRect toRect() {
        switch (this.alignment) {
            case CENTER: {
                return ScreenRect.fromWidthCentered(this.x, this.y, this.width, this.height);
            }
        }
        return ScreenRect.fromWidth(this.x, this.y, this.width, this.height);
    }

    public static BlitCoordinates fromRect(ScreenRect rect) {
        return rect.toBlitCoordinates();
    }

    static enum Alignment {
        DEFAULT,
        CENTER;

    }
}

