/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.network.packets.mod;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.addy4ever.nivarion.Nivarion;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;

public class RespondModListPacket {
    private final boolean allow;

    public RespondModListPacket(boolean allow) {
        this.allow = allow;
    }

    public static void encode(RespondModListPacket msg, ByteBuf buf) {
        FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(buf);
        friendlyByteBuf.writeBoolean(msg.allow);
    }

    public static RespondModListPacket decode(FriendlyByteBuf buf) {
        return new RespondModListPacket(buf.readBoolean());
    }

    public static void handle(RespondModListPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (!msg.allow) {
                ArrayList list = new ArrayList();
                ModList.get().getMods().forEach(mod -> {
                    list.add(mod.getModId());
                    list.add(mod.getDisplayName());
                });
                Nivarion.triggerAntiCheat(List.of("Additional mods detected that are not whitelisted.", "Please remove them immediately."), 1, "Unerw\u00fcnschte Mods", list);
            }
        });
        ctx.setPacketHandled(true);
    }
}

