/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.network.packets.crates;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.addy4ever.nivarion.crates.CrateItem;
import net.addy4ever.nivarion.crates.CrateOpeningScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class StartCrateAnimationPacket {
    private final CrateItem awardedItem;
    private final List<CrateItem> possibleRewards;

    public StartCrateAnimationPacket(CrateItem awardedItem, List<CrateItem> possibleRewards) {
        this.awardedItem = awardedItem;
        this.possibleRewards = possibleRewards;
    }

    public static void encode(StartCrateAnimationPacket msg, FriendlyByteBuf buf) {
        msg.awardedItem.serialize(buf);
        buf.writeInt(msg.possibleRewards.size());
        msg.possibleRewards.forEach(crateItem -> crateItem.serialize(buf));
    }

    public static StartCrateAnimationPacket decode(FriendlyByteBuf buf) {
        CrateItem reward = CrateItem.deserialize(buf);
        int size = buf.readInt();
        ArrayList<CrateItem> possibleRewards = new ArrayList<CrateItem>(size);
        for (int i = 0; i < size; ++i) {
            possibleRewards.add(CrateItem.deserialize(buf));
        }
        return new StartCrateAnimationPacket(reward, possibleRewards);
    }

    public static void handle(StartCrateAnimationPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.m_91152_((Screen)new CrateOpeningScreen(msg.awardedItem, msg.possibleRewards));
            }
        });
        ctx.setPacketHandled(true);
    }
}

