/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.anticheat.client.packets;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.addy4ever.nivarion.anticheat.client.AntiCheatPacket;
import net.minecraft.world.entity.player.Player;

public class OnlinePlayerUpdatePacket
extends AntiCheatPacket {
    private ConnectionType connectionType;
    private String playerName;
    private UUID playerUUID;

    public OnlinePlayerUpdatePacket(ConnectionType connectionType, Player player) {
        super(1);
        this.connectionType = connectionType;
        if (player != null) {
            this.playerName = player.m_7755_().getString();
            this.playerUUID = player.m_20148_();
        }
    }

    @Override
    public void encode(ByteBuf byteBuf) {
        byteBuf.writeInt(this.connectionType.ordinal());
        byteBuf.writeLong(this.playerUUID.getMostSignificantBits());
        byteBuf.writeLong(this.playerUUID.getLeastSignificantBits());
        byteBuf.writeInt(this.playerName.length());
        byteBuf.writeCharSequence((CharSequence)this.playerName, StandardCharsets.UTF_8);
    }

    @Override
    public void decode(ByteBuf byteBuf) {
        this.connectionType = ConnectionType.values()[byteBuf.readInt()];
        this.playerUUID = new UUID(byteBuf.readLong(), byteBuf.readLong());
        this.playerName = byteBuf.readCharSequence(byteBuf.readInt(), StandardCharsets.UTF_8).toString();
    }

    @Override
    public void handle(Channel channel) {
    }

    public static enum ConnectionType {
        JOIN,
        QUIT;

    }
}

