/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.anticheat.client.packets;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.addy4ever.nivarion.anticheat.client.AntiCheatPacket;

public class CaughtXRayPacket
extends AntiCheatPacket {
    private String name;
    private UUID uuid;
    private List<String> resourcePackNames;

    public CaughtXRayPacket(List<String> resourcePackNames, String name, UUID uuid) {
        super(3);
        this.resourcePackNames = resourcePackNames;
        this.name = name;
        this.uuid = uuid;
    }

    @Override
    public void encode(ByteBuf byteBuf) {
        byteBuf.writeInt(this.name.length());
        byteBuf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
        byteBuf.writeLong(this.uuid.getMostSignificantBits());
        byteBuf.writeLong(this.uuid.getLeastSignificantBits());
        byteBuf.writeInt(this.resourcePackNames.size());
        for (String str : this.resourcePackNames) {
            byteBuf.writeInt(str.length());
            byteBuf.writeCharSequence((CharSequence)str, StandardCharsets.UTF_8);
        }
    }

    @Override
    public void decode(ByteBuf byteBuf) {
        this.name = byteBuf.readCharSequence(byteBuf.readInt(), StandardCharsets.UTF_8).toString();
        this.uuid = new UUID(byteBuf.readLong(), byteBuf.readLong());
        int size = byteBuf.readInt();
        ArrayList<String> resourcePackNames = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            resourcePackNames.add(byteBuf.readCharSequence(byteBuf.readInt(), StandardCharsets.UTF_8).toString());
        }
        this.resourcePackNames = resourcePackNames;
    }

    @Override
    public void handle(Channel channel) {
    }
}

