/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.anticheat.client.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import net.addy4ever.nivarion.anticheat.client.AntiCheatPacket;
import net.addy4ever.nivarion.anticheat.client.packets.CaughtModsPacket;
import net.addy4ever.nivarion.anticheat.client.packets.CaughtXRayPacket;
import net.addy4ever.nivarion.anticheat.client.packets.OnlineCountPacket;
import net.addy4ever.nivarion.anticheat.client.packets.OnlinePlayerMessagePacket;
import net.addy4ever.nivarion.anticheat.client.packets.OnlinePlayerUpdatePacket;

public class AntiCheatDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (byteBuf.readableBytes() < 8) {
            return;
        }
        byteBuf.markReaderIndex();
        try {
            AntiCheatPacket antiCheatPacket;
            int packetId = byteBuf.readInt();
            int packetSize = byteBuf.readInt();
            if (byteBuf.readableBytes() < packetSize) {
                byteBuf.resetReaderIndex();
                return;
            }
            switch (packetId) {
                case 0: {
                    AntiCheatPacket antiCheatPacket2 = new OnlineCountPacket(-1);
                    break;
                }
                case 1: {
                    AntiCheatPacket antiCheatPacket2 = new OnlinePlayerUpdatePacket(null, null);
                    break;
                }
                case 2: {
                    AntiCheatPacket antiCheatPacket2 = new OnlinePlayerMessagePacket(null, null, null, null);
                    break;
                }
                case 3: {
                    AntiCheatPacket antiCheatPacket2 = new CaughtXRayPacket(null, null, null);
                    break;
                }
                case 4: {
                    AntiCheatPacket antiCheatPacket2 = new CaughtModsPacket(null, null, null);
                    break;
                }
                default: {
                    AntiCheatPacket antiCheatPacket2 = antiCheatPacket = null;
                }
            }
            if (antiCheatPacket != null) {
                antiCheatPacket.decode(byteBuf);
                antiCheatPacket.handle(channelHandlerContext.channel());
                list.add(antiCheatPacket);
            } else {
                byteBuf.skipBytes(packetSize);
                System.err.println("Unknown packet ID encountered: 0x" + Integer.toHexString(packetId) + ". Skipping " + packetSize + " bytes.");
            }
        }
        catch (IndexOutOfBoundsException e) {
            byteBuf.resetReaderIndex();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Critical decoding error. Closing channel.");
            channelHandlerContext.close();
        }
    }
}

