/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.anticheat;

import com.mojang.brigadier.CommandDispatcher;
import net.addy4ever.nivarion.anticheat.AntiCheatCommand;
import net.addy4ever.nivarion.anticheat.client.AntiCheatClient;
import net.addy4ever.nivarion.anticheat.client.packets.OnlinePlayerMessagePacket;
import net.addy4ever.nivarion.anticheat.client.packets.OnlinePlayerUpdatePacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nivarion", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AntiCheatListener {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onServerStarting(RegisterCommandsEvent event) {
        AntiCheatCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        AntiCheatClient.getInstance().sendPacket(new OnlinePlayerUpdatePacket(OnlinePlayerUpdatePacket.ConnectionType.JOIN, player));
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        AntiCheatClient.getInstance().sendPacket(new OnlinePlayerUpdatePacket(OnlinePlayerUpdatePacket.ConnectionType.QUIT, player));
    }

    @SubscribeEvent
    public static void onClientChat(ServerChatEvent event) {
        String message = event.getRawText();
        ServerPlayer serverPlayer = event.getPlayer();
        AntiCheatClient.getInstance().sendPacket(new OnlinePlayerMessagePacket(OnlinePlayerMessagePacket.MessageType.PUBLIC, serverPlayer.m_7755_().getString(), null, message));
    }

    @SubscribeEvent
    public static void onCommandExecution(CommandEvent event) {
        CommandSourceStack source = (CommandSourceStack)event.getParseResults().getContext().getSource();
        Entity entity = source.m_81373_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player sender = (Player)entity;
        String[] commandName = event.getParseResults().getReader().getString().trim().split(" ", 3);
        String name = commandName[0];
        if ((name.equalsIgnoreCase("tell") || name.equalsIgnoreCase("msg") || name.equalsIgnoreCase("w")) && commandName.length >= 3) {
            String recipientName = commandName[1];
            String content = commandName[2];
            AntiCheatClient.getInstance().sendPacket(new OnlinePlayerMessagePacket(OnlinePlayerMessagePacket.MessageType.PRIVATE, sender.m_7755_().getString(), recipientName, content));
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        AntiCheatClient.shutdown = true;
        if (AntiCheatClient.getInstance().getSocket() != null) {
            try {
                AntiCheatClient.getInstance().getSocket().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

