/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers.vfx;

import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.vfx.Color;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.floats.Float2ReferenceAVLTreeMap;
import it.unimi.dsi.fastutil.floats.Float2ReferenceMap;
import it.unimi.dsi.fastutil.floats.Float2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2ReferenceSortedMap;
import it.unimi.dsi.fastutil.floats.Float2ReferenceSortedMaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.random.RandomGenerator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public final class VFXHelper {
    public static final Float2ReferenceSortedMap<Vector2i[]> SHOCKWAVE_OFFSETS = VFXHelper.getOffsets(16);
    private static final Vector3f[][] arcs = VFXHelper.getRandomArcs(new Random(), 8, 48);
    private static final int WIND_SEGMENTS = 48;
    public static final float WIND_INCR = 0.1308997f;
    public static final Color WIND_BASE = Color.WHITE.scaleAlpha(0.4f);

    public static float lengthSqr(Vector3f vec) {
        return MathHelper.distSqr(vec.x(), vec.y(), vec.z());
    }

    public static float length(Vector3f vec) {
        return MathHelper.dist(vec.x(), vec.y(), vec.z());
    }

    public static VFXNode interpolate(VFXNode a, VFXNode b, float d) {
        return new VFXNode(MathHelper.interpolate(a.xp, b.xp, d), MathHelper.interpolate(a.xn, b.xn, d), MathHelper.interpolate(a.yp, b.yp, d), MathHelper.interpolate(a.yn, b.yn, d), MathHelper.interpolate(a.z, b.z, d), MathHelper.interpolate(a.width, b.width, d));
    }

    public static Vector4f interpolate(Vector4f a, Vector4f b, float d) {
        return new Vector4f(MathHelper.interpolate(a.x(), b.x(), d), MathHelper.interpolate(a.y(), b.y(), d), MathHelper.interpolate(a.z(), b.z(), d), MathHelper.interpolate(a.w(), b.w(), d));
    }

    private static VFXNode interpolateCap(VFXNode a, VFXNode b) {
        return VFXHelper.interpolate(a, b, 1.0f + b.width * 0.5f / MathHelper.dist(a.xMid() - b.xMid(), a.yMid() - b.yMid(), a.z - b.z));
    }

    public static Vector4f subtract(Vector4f a, Vector4f b) {
        return new Vector4f(a.x() - b.x(), a.y() - b.y(), a.z() - b.z(), a.w() - b.w());
    }

    public static Vector3f normal(Matrix3f transform) {
        return new Vector3f(0.0f, 1.0f, 0.0f).mul((Matrix3fc)transform);
    }

    public static Vector3f normal(PoseStack stack) {
        return VFXHelper.normal(stack.m_85850_().m_252943_());
    }

    public static Vector4f mid(Vector4f a, Vector4f b) {
        return new Vector4f((a.x() + b.x()) * 0.5f, (a.y() + b.y()) * 0.5f, (a.z() + b.z()) * 0.5f, (a.w() + b.w()) * 0.5f);
    }

    public static void renderNodes(Vector3f normal, VertexConsumer builder, int packedLight, VFXNode[] nodes, Color color) {
        nodes[0].renderStart(normal, builder, packedLight, color);
        int count = nodes.length - 1;
        for (int i = 1; i < count; ++i) {
            nodes[i].renderMid(normal, builder, packedLight, color);
        }
        nodes[count].renderEnd(normal, builder, packedLight, color);
    }

    public static void renderNodesCapped(Vector3f normal, MultiBufferSource buffer, RenderType midType, RenderType capType, int packedLight, VFXNode[] nodes, Color color) {
        if (nodes.length < 2) {
            return;
        }
        VertexConsumer consumer = buffer.m_6299_(midType);
        VFXHelper.renderNodes(normal, consumer, packedLight, nodes, color);
        consumer = buffer.m_6299_(capType);
        VFXHelper.interpolateCap(nodes[1], nodes[0]).renderStart(normal, consumer, packedLight, color, 0.0f, 0.0f, 1.0f, 0.5f);
        nodes[0].renderEnd(normal, consumer, packedLight, color, 0.0f, 0.0f, 1.0f, 0.5f);
        nodes[nodes.length - 1].renderStart(normal, consumer, packedLight, color, 0.0f, 0.5f, 1.0f, 1.0f);
        VFXHelper.interpolateCap(nodes[nodes.length - 2], nodes[nodes.length - 1]).renderEnd(normal, consumer, packedLight, color, 0.0f, 0.5f, 1.0f, 1.0f);
    }

    public static Vector2f axialPerp(Vector4f start, Vector4f end, float width) {
        float x = -start.x();
        float y = -start.y();
        if (Math.abs(start.z()) > 0.0f) {
            float ratio = end.z() / start.z();
            x = end.x() + x * ratio;
            y = end.y() + y * ratio;
        } else if (Math.abs(end.z()) <= 0.0f) {
            x += end.x();
            y += end.y();
        }
        if (start.z() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / MathHelper.dist(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vector2f(-y, x);
    }

    public static Vector2f axialPerp(Vector3f start, Vector3f end, float width) {
        float x = -start.x();
        float y = -start.y();
        if (Math.abs(start.z()) > 0.0f) {
            float ratio = end.z() / start.z();
            x = end.x() + x * ratio;
            y = end.y() + y * ratio;
        } else if (Math.abs(end.z()) <= 0.0f) {
            x += end.x();
            y += end.y();
        }
        if (start.z() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / MathHelper.dist(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vector2f(-y, x);
    }

    public static Quaternionf alignVertical(Vector3f dir) {
        if (dir.x() == 0.0f && dir.y() == 0.0f && dir.z() == 0.0f) {
            return new Quaternionf();
        }
        return MathHelper.rotation(new Vector3f((Vector3fc)dir).normalize().add(0.0f, 1.0f, 0.0f).normalize(), (float)Math.PI);
    }

    public static void alignVertical(PoseStack stack, Vector3f dir) {
        stack.m_252781_(VFXHelper.alignVertical(dir));
    }

    public static void alignVertical(PoseStack stack, Vector3f start, Vector3f end) {
        Vector3f diff = new Vector3f((Vector3fc)end);
        diff.sub((Vector3fc)start);
        float scale = VFXHelper.length(diff);
        stack.m_252880_(start.x(), start.y(), start.z());
        VFXHelper.alignVertical(stack, diff);
        stack.m_85841_(scale, scale, scale);
    }

    public static void renderTest(PoseStack stack, VertexConsumer consumer) {
        Vector4f center = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f).mul((Matrix4fc)stack.m_85850_().m_252922_());
        Matrix3f normal = stack.m_85850_().m_252943_();
        float xp = center.x() + 0.5f;
        float xn = center.x() - 0.5f;
        float yp = center.y() + 0.5f;
        float yn = center.y() - 0.5f;
        float z = center.z();
        int r = 255;
        int g = 255;
        int b = 255;
        int a = 255;
        int overlay = OverlayTexture.m_118090_((float)0.0f, (boolean)false);
        consumer.m_5483_((double)xp, (double)yp, (double)z).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_5483_((double)xn, (double)yp, (double)z).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_5483_((double)xn, (double)yn, (double)z).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_5483_((double)xp, (double)yn, (double)z).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderTest(PoseStack stack, MultiBufferSource buffer) {
        VFXHelper.renderTest(stack, buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT));
    }

    public static void renderTest(PoseStack stack) {
        VFXHelper.renderTest(stack, (MultiBufferSource)RenderHelper.bufferSource());
    }

    private static void renderSkeleton(VertexConsumer builder, VFXNode[] nodes) {
        VFXNode node = nodes[0];
        float xm = node.xMid();
        float ym = node.yMid();
        builder.m_5483_((double)node.xp, (double)node.yp, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
        builder.m_5483_((double)node.xn, (double)node.yn, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 255, 255, 255).m_5752_();
        for (int i = 1; i < nodes.length - 1; ++i) {
            node = nodes[i];
            xm = node.xMid();
            ym = node.yMid();
            builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 255, 255, 255).m_5752_();
            builder.m_5483_((double)node.xp, (double)node.yp, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
            builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
            builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
            builder.m_5483_((double)node.xn, (double)node.yn, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
            builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 255, 255, 255).m_5752_();
        }
        node = nodes[nodes.length - 1];
        xm = node.xMid();
        ym = node.yMid();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 255, 255, 255).m_5752_();
        builder.m_5483_((double)node.xp, (double)node.yp, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
        builder.m_5483_((double)node.xn, (double)node.yn, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
    }

    private static void renderSkeleton(VFXNode[] nodes) {
        VFXHelper.renderSkeleton(Minecraft.m_91087_().m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_), nodes);
    }

    public static void renderShockwave(PoseStack stack, MultiBufferSource buffer, Level level, BlockPos origin, float time, float radius, float heightScale, BiPredicate<BlockPos, BlockState> canRender) {
        BlockRenderDispatcher renderer = RenderHelper.renderBlock();
        float invRadius = 1.0f / radius;
        for (Float2ReferenceMap.Entry entry : SHOCKWAVE_OFFSETS.subMap(Math.min(time - 5.0f, radius), Math.min(time, radius)).float2ReferenceEntrySet()) {
            float dist = entry.getFloatKey();
            float progress = time - dist;
            double height = (double)heightScale * 0.16 * (double)(radius - dist * 0.5f) * (double)progress * (double)(5.0f - progress) * (double)invRadius / (double)Math.max(dist * 0.25f, 1.0f);
            block1: for (Vector2i offset : (Vector2i[])entry.getValue()) {
                for (int y = 1; y >= -1; --y) {
                    BlockState state;
                    BlockPos pos = origin.m_7918_(offset.x, y, offset.y);
                    if (!canRender.test(pos, state = level.m_8055_(pos))) continue;
                    if (state.m_60799_() != RenderShape.MODEL) continue block1;
                    stack.m_85836_();
                    stack.m_85837_((double)offset.x, height + (double)y, (double)offset.y);
                    stack.m_85841_(1.01f, 1.01f, 1.01f);
                    for (RenderType type : renderer.m_110910_(state).getRenderTypes(state, level.f_46441_, ModelData.EMPTY)) {
                        renderer.renderBatched(state, pos.m_121945_(Direction.UP), (BlockAndTintGetter)level, stack, buffer.m_6299_(type), false, level.f_46441_, ModelData.EMPTY, type);
                    }
                    stack.m_85849_();
                    continue block1;
                }
            }
        }
    }

    public static void renderShockwave(PoseStack stack, MultiBufferSource buffer, Level world, BlockPos origin, float time, float radius, float heightScale) {
        VFXHelper.renderShockwave(stack, buffer, world, origin, time, radius, heightScale, (pos, state) -> !state.m_60795_() && state.m_60796_((BlockGetter)world, pos) && state.m_60838_((BlockGetter)world, pos) && !state.m_155947_() && !world.m_8055_(pos.m_7494_()).m_60838_((BlockGetter)world, pos.m_7494_()));
    }

    private static Float2ReferenceSortedMap<Vector2i[]> getOffsets(int maxRadius) {
        Float2ReferenceOpenHashMap blocks = new Float2ReferenceOpenHashMap();
        float maxSqr = maxRadius * maxRadius;
        for (int x = -maxRadius; x <= maxRadius; ++x) {
            for (int z = -maxRadius; z <= maxRadius; ++z) {
                int distSqr = x * x + z * z;
                if (!((float)distSqr < maxSqr)) continue;
                float dist = MathHelper.sqrt(distSqr);
                ((List)blocks.computeIfAbsent(dist, d -> new ArrayList())).add(new Vector2i(x, z));
            }
        }
        Float2ReferenceAVLTreeMap out = new Float2ReferenceAVLTreeMap();
        blocks.float2ReferenceEntrySet().forEach(arg_0 -> VFXHelper.lambda$getOffsets$3((Float2ReferenceSortedMap)out, arg_0));
        return Float2ReferenceSortedMaps.unmodifiable((Float2ReferenceSortedMap)out);
    }

    public static void renderStraightArcs(PoseStack stack, MultiBufferSource buffer, int packedLight, int arcCount, float arcWidth, float widthVar, long seed, Color coreColor, Color glowColor, float taperOffset) {
        SplittableRandom rand = new SplittableRandom(seed);
        int nodeCount = arcs[0].length;
        int first = MathHelper.clamp((int)((float)nodeCount * (taperOffset - 0.25f) + 1.0f), 0, nodeCount);
        int last = MathHelper.clamp((int)((float)nodeCount * (1.25f + taperOffset) + 1.0f), 0, nodeCount);
        if (last - first <= 1) {
            return;
        }
        stack.m_85836_();
        Matrix4f pose = stack.m_85850_().m_252922_();
        Vector3f normal = VFXHelper.normal(stack);
        Vector2f perp = VFXHelper.axialPerp(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f).mul((Matrix4fc)pose), new Vector4f(0.0f, 1.0f, 0.0f, 1.0f).mul((Matrix4fc)pose), 1.0f);
        Vector3f[][] randomArcs = new Vector3f[nodeCount][arcCount];
        float[] rotations = new float[arcCount];
        for (int i = 0; i < arcCount; ++i) {
            randomArcs[i] = arcs[rand.nextInt(arcs.length)];
            rotations[i] = (float)rand.nextDouble(360.0);
        }
        float incr = 1.0f / (float)nodeCount;
        for (int i = 0; i < arcCount; ++i) {
            stack.m_252781_(Axis.f_252436_.m_252977_(rotations[i]));
            Vector3f[] arc = randomArcs[i];
            VFXNode[] outer = new VFXNode[last - first];
            VFXNode[] inner = new VFXNode[last - first];
            for (int j = first; j < last; ++j) {
                Vector4f center = new Vector4f(0.0f, arc[j].y(), 0.0f, 1.0f).mul((Matrix4fc)pose);
                Vector4f pos = MathHelper.toVector4f(arc[j]).mul((Matrix4fc)pose);
                float dot = VFXHelper.subtract(pos, center).dot((Vector4fc)new Vector4f(perp.x, perp.y, 0.0f, 0.0f));
                float xc = center.x() + perp.x * dot * 3.0f;
                float yc = center.y() + perp.y * dot * 3.0f;
                float width = Math.max(arcWidth + (float)rand.nextDouble(-1.0, 1.0) * widthVar, 0.0f) * MathHelper.clamp(4.0f * (0.75f - Math.abs((float)j * incr - 0.5f - taperOffset)), 0.0f, 1.0f);
                float xw = perp.x * width;
                float yw = perp.y * width;
                inner[j - first] = new VFXNode(xc + xw, xc - xw, yc + yw, yc - yw, center.z(), width);
                width = Math.max(width, arcWidth);
                outer[j - first] = new VFXNode(xc + (xw += perp.x * width * 1.5f), xc - xw, yc + (yw += perp.y * width * 1.5f), yc - yw, center.z(), width);
            }
            VFXHelper.renderNodesCapped(normal, buffer, RenderTypes.LINEAR_GLOW, RenderTypes.ROUND_GLOW, packedLight, outer, glowColor);
            VFXHelper.renderNodesCapped(normal, buffer, RenderTypes.LINEAR_GLOW, RenderTypes.ROUND_GLOW, packedLight, inner, coreColor);
        }
        stack.m_85849_();
    }

    public static void renderStraightArcs(PoseStack stack, MultiBufferSource buffer, int packedLightIn, int arcCount, float arcWidth, long seed, Color coreColor, Color glowColor, float taperOffset) {
        VFXHelper.renderStraightArcs(stack, buffer, packedLightIn, arcCount, arcWidth, 0.3f * arcWidth, seed, coreColor, glowColor, taperOffset);
    }

    public static void renderStraightArcs(PoseStack stack, MultiBufferSource buffer, int packedLightIn, float length, int arcCount, float arcWidth, long seed, Color coreColor, Color glowColor, float taperOffset) {
        stack.m_85836_();
        stack.m_85841_(length, length, length);
        VFXHelper.renderStraightArcs(stack, buffer, packedLightIn, arcCount, arcWidth / Math.abs(length), seed, coreColor, glowColor, taperOffset);
        stack.m_85849_();
    }

    public static long getSeedWithTime(long seed, float time, float flickerRate) {
        return seed + (long)(69420 * (int)(time * flickerRate));
    }

    public static long getSeedWithTime(long seed, float time) {
        return VFXHelper.getSeedWithTime(seed, time, 0.75f);
    }

    public static float getTaperOffsetFromTimes(float time, float endTime, float taperTime) {
        float offset = 0.0f;
        if (time < taperTime) {
            offset = 1.25f * (time - taperTime) / taperTime;
        } else if (endTime - time < taperTime) {
            offset = 1.25f * (time + taperTime - endTime) / taperTime;
        }
        return offset;
    }

    public static float getTaperOffsetFromTimes(float time, float startTime, float endTime, float taperTime) {
        return VFXHelper.getTaperOffsetFromTimes(time - startTime, endTime - startTime, taperTime);
    }

    private static Vector3f[][] getRandomArcs(Random random, int arcCount, int nodeCount) {
        Vector3f[][] arcs = new Vector3f[arcCount][nodeCount];
        for (int i = 0; i < arcs.length; ++i) {
            arcs[i] = VFXHelper.getRandomNodes(random, nodeCount);
        }
        return arcs;
    }

    private static Vector3f[] getRandomNodes(Random random, int count) {
        int i;
        TreeSet<Float> ySet = new TreeSet<Float>();
        float e = 0.25f / (float)count;
        ySet.add(Float.valueOf(0.0f));
        ySet.add(Float.valueOf(1.0f));
        count -= 2;
        for (i = 0; i < count * 3 && ySet.size() < count; ++i) {
            float next = random.nextFloat();
            if (ySet.subSet(Float.valueOf(next - e), Float.valueOf(next + e)).size() > 0) continue;
            ySet.add(Float.valueOf(next));
        }
        for (i = count - ySet.size(); i > 0; --i) {
            ySet.add(Float.valueOf(random.nextFloat()));
        }
        Float[] y = (Float[])ySet.toArray(Float[]::new);
        Vector3f[] nodes = new Vector3f[y.length];
        nodes[0] = new Vector3f(0.0f, 0.0f, 0.0f);
        nodes[nodes.length - 1] = new Vector3f(0.0f, 1.0f, 0.0f);
        for (int i2 = 1; i2 < nodes.length - 1; ++i2) {
            float eccentricity = 0.3f * (y[i2].floatValue() - y[i2 - 1].floatValue());
            float centering = Math.min(1.0f, 3.0f - 3.0f * (float)i2 / (float)nodes.length);
            nodes[i2] = new Vector3f(centering * nodes[i2 - 1].x() + eccentricity * VFXHelper.boundedGaussian(random, 1.65f), y[i2].floatValue(), centering * nodes[i2 - 1].z() + eccentricity * VFXHelper.boundedGaussian(random, 1.65f));
        }
        return nodes;
    }

    private static float boundedGaussian(Random random, float z) {
        return MathHelper.clamp((float)random.nextGaussian(), -z, z);
    }

    public static void renderBeam(PoseStack stack, MultiBufferSource buffer, int packedLight, float width, Color coreColor, Color glowColor) {
        Matrix4f pose = stack.m_85850_().m_252922_();
        Vector3f normal = VFXHelper.normal(stack);
        Vector4f start = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f).mul((Matrix4fc)pose);
        Vector4f end = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f).mul((Matrix4fc)pose);
        Vector2f perp = VFXHelper.axialPerp(start, end, width);
        float sx = start.x();
        float sy = start.y();
        float sz = start.z();
        float ex = end.x();
        float ey = end.y();
        float ez = end.z();
        VFXNode[] outer = new VFXNode[]{new VFXNode(sx + perp.x, sx - perp.x, sy + perp.y, sy - perp.y, sz, width), new VFXNode(ex + perp.x, ex - perp.x, ey + perp.y, ey - perp.y, ez, width)};
        perp.mul(0.5f);
        VFXNode[] inner = new VFXNode[]{new VFXNode(sx + perp.x, sx - perp.x, sy + perp.y, sy - perp.y, sz, width *= 0.5f), new VFXNode(ex + perp.x, ex - perp.x, ey + perp.y, ey - perp.y, ez, width)};
        VFXHelper.renderNodesCapped(normal, buffer, RenderTypes.LINEAR_GLOW, RenderTypes.ROUND_GLOW, packedLight, outer, glowColor);
        VFXHelper.renderNodesCapped(normal, buffer, RenderTypes.LINEAR_GLOW, RenderTypes.ROUND_GLOW, packedLight, inner, coreColor);
    }

    public static Float2FloatFunction getWidthFunc(float width) {
        return index -> width * MathHelper.easePlateau(index);
    }

    public static Color windColor(RandomGenerator random) {
        return WIND_BASE.scaleRGB(random.nextFloat(0.65f, 1.0f));
    }

    public static Color windColor(RandomSource random) {
        return WIND_BASE.scaleRGB(random.m_188501_() * 0.35f + 0.65f);
    }

    public static void renderStreamLine(PoseStack stack, VertexConsumer builder, int packedLight, Vector4f[] posns, Color color, Float2FloatFunction widthFunc) {
        if (posns.length < 2) {
            return;
        }
        if (color.a <= 0) {
            return;
        }
        Matrix4f pose = stack.m_85850_().m_252922_();
        Vector3f normal = VFXHelper.normal(stack);
        for (Vector4f pos : posns) {
            pos.mul((Matrix4fc)pose);
        }
        int last = posns.length - 1;
        VFXNode[] nodes = new VFXNode[posns.length];
        float increment = 1.0f / (float)last;
        for (int i = 1; i < last; ++i) {
            float width = ((Float)widthFunc.apply((Object)Float.valueOf(increment * (float)i))).floatValue();
            nodes[i] = new VFXNode(posns[i], VFXHelper.axialPerp(posns[i - 1], posns[i + 1], width), width);
        }
        float width = ((Float)widthFunc.apply((Object)Float.valueOf(0.0f))).floatValue();
        nodes[0] = new VFXNode(posns[0], VFXHelper.axialPerp(posns[0], posns[1], width), width);
        width = ((Float)widthFunc.apply((Object)Float.valueOf(1.0f))).floatValue();
        nodes[last] = new VFXNode(posns[last], VFXHelper.axialPerp(posns[last - 1], posns[last], width), width);
        VFXHelper.renderNodes(normal, builder, packedLight, nodes, color);
    }

    public static void renderCyclone(PoseStack stack, VertexConsumer consumer, int packedLight, Color color, float radius, float thickness, int length, float rot, float y) {
        Vector4f[] nodes = new Vector4f[length];
        for (int j = 0; j < length; ++j) {
            float angle = (float)j * 0.1308997f + rot;
            nodes[j] = new Vector4f(MathHelper.cos(angle) * radius, y, MathHelper.sin(angle) * radius, 1.0f);
        }
        VFXHelper.renderStreamLine(stack, consumer, packedLight, nodes, color, VFXHelper.getWidthFunc(thickness));
    }

    public static void renderCyclone(PoseStack stack, VertexConsumer consumer, int packedLight, Color color, float radius, float thickness, float height, RandomGenerator rand, float time) {
        VFXHelper.renderCyclone(stack, consumer, packedLight, color, radius, thickness, rand.nextInt(24, 48), (rand.nextFloat(-1.0f, 1.0f) + 6.0f) * (time += rand.nextFloat(420.0f)), (rand.nextFloat() + MathHelper.cos(time * 0.2f)) * 0.25f * height);
    }

    private static /* synthetic */ void lambda$getOffsets$3(Float2ReferenceSortedMap out, Float2ReferenceMap.Entry entry) {
        out.put(entry.getFloatKey(), (Object)((Vector2i[])((List)entry.getValue()).toArray(Vector2i[]::new)));
    }

    public static class VFXNode {
        public final float xp;
        public final float xn;
        public final float yp;
        public final float yn;
        public final float z;
        public final float width;

        public VFXNode(float xp, float xn, float yp, float yn, float z, float width) {
            this.xp = xp;
            this.xn = xn;
            this.yp = yp;
            this.yn = yn;
            this.z = z;
            this.width = width;
        }

        public VFXNode(Vector4f pos, Vector2f perp, float width) {
            this(pos.x() + perp.x, pos.x() - perp.x, pos.y() + perp.y, pos.y() - perp.y, pos.z(), width);
        }

        public VFXNode(float xp, float xn, float yp, float yn, float z) {
            this(xp, xn, yp, yn, z, MathHelper.dist(xp - xn, yp - yn));
        }

        public float xMid() {
            return (this.xp + this.xn) * 0.5f;
        }

        public float yMid() {
            return (this.yp + this.yn) * 0.5f;
        }

        public VFXNode renderStart(Vector3f normal, VertexConsumer builder, int packedLight, Color col, float u0, float v0, float u1, float v1) {
            builder.m_5483_((double)this.xp, (double)this.yp, (double)this.z).m_6122_(col.r, col.g, col.b, col.a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal.x, normal.y, normal.z).m_5752_();
            builder.m_5483_((double)this.xn, (double)this.yn, (double)this.z).m_6122_(col.r, col.g, col.b, col.a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal.x, normal.y, normal.z).m_5752_();
            return this;
        }

        public VFXNode renderStart(Vector3f normal, VertexConsumer builder, int packedLight, Color color) {
            return this.renderStart(normal, builder, packedLight, color, 0.0f, 0.0f, 1.0f, 1.0f);
        }

        public VFXNode renderEnd(Vector3f normal, VertexConsumer builder, int packedLight, Color col, float u0, float v0, float u1, float v1) {
            builder.m_5483_((double)this.xn, (double)this.yn, (double)this.z).m_6122_(col.r, col.g, col.b, col.a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal.x, normal.y, normal.z).m_5752_();
            builder.m_5483_((double)this.xp, (double)this.yp, (double)this.z).m_6122_(col.r, col.g, col.b, col.a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(normal.x, normal.y, normal.z).m_5752_();
            return this;
        }

        public VFXNode renderEnd(Vector3f normal, VertexConsumer builder, int packedLight, Color color) {
            return this.renderEnd(normal, builder, packedLight, color, 0.0f, 0.0f, 1.0f, 1.0f);
        }

        public VFXNode renderMid(Vector3f normal, VertexConsumer builder, int packedLight, Color col, float u0, float v0, float u1, float v1, float u2, float v2, float u3, float v3) {
            this.renderEnd(normal, builder, packedLight, col, u0, v0, u1, v1);
            this.renderStart(normal, builder, packedLight, col, u2, v2, u3, v3);
            return this;
        }

        public VFXNode renderMid(Vector3f normal, VertexConsumer builder, int packedLight, Color col, float u0, float v0, float u1, float v1, float u2, float v2) {
            return this.renderMid(normal, builder, packedLight, col, u0, v0, u1, v1, u1, v1, u2, v2);
        }

        public VFXNode renderMid(Vector3f normal, VertexConsumer builder, int packedLight, Color col, float u0, float v0, float u1, float v1) {
            return this.renderMid(normal, builder, packedLight, col, u0, v0, u1, v1, u0, v0, u1, v1);
        }

        public VFXNode renderMid(Vector3f normal, VertexConsumer builder, int packedLight, Color col) {
            return this.renderMid(normal, builder, packedLight, col, 0.0f, 0.0f, 1.0f, 1.0f);
        }

        public String toString() {
            return "{" + this.xp + ", " + this.xn + "}, {" + this.yp + ", " + this.yn + "}, " + this.z;
        }
    }
}

