/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.mapping;

import dev.arbor.extrasoundsnext.annotation.SoundsGenerator;
import dev.arbor.extrasoundsnext.annotation.SoundsGeneratorFabic;
import dev.arbor.extrasoundsnext.mapping.SoundDefinition;
import dev.arbor.extrasoundsnext.mapping.SoundGenerator;
import dev.arbor.extrasoundsnext.sounds.Categories;
import dev.arbor.extrasoundsnext.sounds.Sounds;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiscFragmentItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.EmptyMapItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemFrameItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.KnowledgeBookItem;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SugarCaneBlock;
import org.jetbrains.annotations.NotNull;

public final class DefaultAutoGenerator
implements SoundsGeneratorFabic {
    @SoundsGenerator
    public static final SoundGenerator generator = SoundGenerator.of("minecraft", DefaultAutoGenerator::autoGenerator);

    public static SoundDefinition autoGenerator(Item item) {
        if (item instanceof RecordItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.MUSIC_DISC));
        }
        if (item instanceof BoatItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.BOAT));
        }
        if (item instanceof TieredItem) {
            TieredItem toolItem = (TieredItem)item;
            Tier tier = toolItem.m_43314_();
            if (tier instanceof Tiers) {
                Tiers mat = (Tiers)tier;
                return DefaultAutoGenerator.getTierItemSound(mat);
            }
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.GENERIC));
        }
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            ArmorMaterial armorMaterial = armorItem.m_40401_();
            if (armorMaterial instanceof ArmorMaterials) {
                ArmorMaterials mat = (ArmorMaterials)armorMaterial;
                return DefaultAutoGenerator.getArmorMaterialSound(mat);
            }
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.GENERIC));
        }
        if (item instanceof ShieldItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.IRON));
        }
        if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            return SoundGenerator.getBucketItemSound(bucketItem);
        }
        if (item instanceof MinecartItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.MINECART));
        }
        if (item instanceof ItemFrameItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.FRAME));
        }
        if (item instanceof PotionItem || item instanceof ExperienceBottleItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.POTION));
        }
        if (item instanceof ArrowItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.ARROW));
        }
        if (item instanceof DyeItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.DUST));
        }
        if (item instanceof SpawnEggItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.WET_SLIPPERY));
        }
        if (item instanceof BowlFoodItem || item instanceof SuspiciousStewItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.BOWL));
        }
        if (item instanceof InstrumentItem) {
            return SoundDefinition.of(Sounds.single(Categories.LOOSE_METAL.m_11660_(), 0.6f, 0.9f, Sound.Type.SOUND_EVENT));
        }
        if (item instanceof SmithingTemplateItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.LOOSE_METAL));
        }
        if (item instanceof DiscFragmentItem) {
            return SoundDefinition.of(Sounds.single(Categories.METAL_BITS.m_11660_(), 0.7f, 0.85f, Sound.Type.SOUND_EVENT));
        }
        if (DefaultAutoGenerator.isBrickItem(item)) {
            return SoundDefinition.of(Sounds.aliased(Categories.BRICK));
        }
        if (DefaultAutoGenerator.isGearGoldenItem(item)) {
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.GOLDEN));
        }
        if (DefaultAutoGenerator.isGearLeatherItem(item)) {
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.LEATHER));
        }
        if (DefaultAutoGenerator.isGearGenericItem(item)) {
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.GENERIC));
        }
        if (DefaultAutoGenerator.isPaperItem(item)) {
            return SoundDefinition.of(Sounds.aliased(Categories.PAPER));
        }
        if (item instanceof BlockItem) {
            RotatedPillarBlock pillarBlock;
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            ResourceLocation blockSound = SoundGenerator.getSoundType(block).m_56777_().m_11660_();
            if (block instanceof BaseRailBlock) {
                return SoundDefinition.of(Sounds.aliased(Categories.RAIL));
            }
            if (block instanceof BannerBlock) {
                return SoundDefinition.of(Sounds.aliased(Categories.BANNER));
            }
            if (block instanceof SeaPickleBlock) {
                return SoundDefinition.of(Sounds.event(blockSound, 0.4f));
            }
            if (block instanceof LeavesBlock || block instanceof BushBlock || block instanceof SugarCaneBlock) {
                ResourceLocation soundId = SoundGenerator.getSoundType(block).m_56777_().m_11660_();
                if (soundId.m_135815_().equals("block.grass.place")) {
                    return SoundDefinition.of(Sounds.aliased(Categories.LEAVES));
                }
                return SoundDefinition.of(Sounds.event(soundId));
            }
            if (block instanceof RotatedPillarBlock && SoundGenerator.getSoundType((Block)(pillarBlock = (RotatedPillarBlock)block)).equals(SoundType.f_222465_)) {
                return SoundDefinition.of(Sounds.event(blockSound, 0.3f));
            }
            return SoundDefinition.of(Sounds.event(blockSound));
        }
        return SoundDefinition.of(Sounds.aliased(Sounds.ITEM_PICK));
    }

    @NotNull
    private static SoundDefinition getArmorMaterialSound(ArmorMaterials mat) {
        return switch (mat) {
            case ArmorMaterials.IRON -> SoundDefinition.of(Sounds.aliased(Categories.Gear.IRON));
            case ArmorMaterials.GOLD -> SoundDefinition.of(Sounds.aliased(Categories.Gear.GOLDEN));
            case ArmorMaterials.DIAMOND -> SoundDefinition.of(Sounds.aliased(Categories.Gear.DIAMOND));
            case ArmorMaterials.NETHERITE -> SoundDefinition.of(Sounds.aliased(Categories.Gear.NETHERITE));
            case ArmorMaterials.CHAIN -> SoundDefinition.of(Sounds.aliased(Categories.Gear.CHAIN));
            case ArmorMaterials.TURTLE -> SoundDefinition.of(Sounds.aliased(Categories.Gear.TURTLE));
            case ArmorMaterials.LEATHER -> SoundDefinition.of(Sounds.aliased(Categories.Gear.LEATHER));
            default -> SoundDefinition.of(Sounds.aliased(Categories.Gear.GENERIC));
        };
    }

    @NotNull
    private static SoundDefinition getTierItemSound(Tiers mat) {
        return switch (mat) {
            case Tiers.WOOD -> SoundDefinition.of(Sounds.aliased(Categories.Gear.WOOD));
            case Tiers.STONE -> SoundDefinition.of(Sounds.aliased(Categories.Gear.STONE));
            case Tiers.IRON -> SoundDefinition.of(Sounds.aliased(Categories.Gear.IRON));
            case Tiers.GOLD -> SoundDefinition.of(Sounds.aliased(Categories.Gear.GOLDEN));
            case Tiers.DIAMOND -> SoundDefinition.of(Sounds.aliased(Categories.Gear.DIAMOND));
            case Tiers.NETHERITE -> SoundDefinition.of(Sounds.aliased(Categories.Gear.NETHERITE));
            default -> SoundDefinition.of(Sounds.aliased(Categories.Gear.GENERIC));
        };
    }

    private static boolean isGearGoldenItem(Item item) {
        return item instanceof HorseArmorItem || item instanceof CompassItem || item instanceof SpyglassItem || item instanceof ShearsItem;
    }

    private static boolean isGearLeatherItem(Item item) {
        return item instanceof LeadItem || item instanceof ElytraItem || item instanceof SaddleItem;
    }

    private static boolean isGearGenericItem(Item item) {
        return item instanceof BowItem || item instanceof CrossbowItem || item instanceof FishingRodItem || item instanceof FoodOnAStickItem;
    }

    private static boolean isPaperItem(Item item) {
        return item instanceof BannerPatternItem || item instanceof BookItem || item instanceof WritableBookItem || item instanceof WrittenBookItem || item instanceof EnchantedBookItem || item instanceof EmptyMapItem || item instanceof MapItem || item instanceof NameTagItem || item instanceof KnowledgeBookItem;
    }

    private static boolean isBrickItem(Item item) {
        return item == Items.f_42460_ || SoundGenerator.getDescriptionId(item).endsWith("pottery_sherd");
    }
}

