/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.gui;

import com.mojang.datafixers.util.Pair;
import dev.arbor.extrasoundsnext.ExtraSoundsNext;
import dev.arbor.extrasoundsnext.sounds.SoundSouceInit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundList
extends ContainerObjectSelectionList<SoundEntry> {
    public SoundList(Minecraft minecraftClient, int i, int j, int k, int l, int m) {
        super(minecraftClient, i, j, k, l, m);
        this.f_93394_ = false;
    }

    public void addSingleOptionEntry(OptionInstance<?> option) {
        this.m_7085_((AbstractSelectionList.Entry)SoundEntry.create(this.f_93386_.f_91066_, this.f_93388_, option));
    }

    public void addOptionEntry(OptionInstance<?> firstOption, @Nullable OptionInstance<?> secondOption) {
        this.m_7085_((AbstractSelectionList.Entry)SoundEntry.createDouble(this.f_93386_.f_91066_, this.f_93388_, firstOption, secondOption));
    }

    public void addAll(OptionInstance<?>[] options) {
        for (int i = 0; i < options.length; i += 2) {
            this.addOptionEntry(options[i], i < options.length - 1 ? options[i + 1] : null);
        }
    }

    public void addCategory(SoundSource cat) {
        this.addSingleOptionEntry(this.createCustomizedOption(cat));
    }

    public void addDoubleCategory(SoundSource first, @Nullable SoundSource second) {
        this.addOptionEntry(this.createCustomizedOption(first), second != null ? this.createCustomizedOption(second) : null);
    }

    public void addAllCategory(SoundSource[] categories) {
        this.addAll((OptionInstance[])Arrays.stream(categories).map(this::createCustomizedOption).toArray(OptionInstance[]::new));
    }

    public void addGroup(SoundSource group, Button.OnPress pressAction) {
        super.m_7085_((AbstractSelectionList.Entry)SoundEntry.createGroup(this.f_93386_.f_91066_, this.createCustomizedOption(group), this.f_93388_, pressAction));
    }

    public int m_5759_() {
        return 400;
    }

    protected int m_5756_() {
        return super.m_5756_() + 32;
    }

    private OptionInstance<?> createCustomizedOption(SoundSource category) {
        OptionInstance simpleOption = this.f_93386_.f_91066_.m_246669_(category);
        if (((Boolean)SoundSouceInit.TOGGLEABLE_CATS.getOrDefault(category, (Pair<Boolean, Boolean>)Pair.of((Object)false, (Object)false)).getFirst()).booleanValue()) {
            return OptionInstance.m_257874_((String)simpleOption.toString(), value -> Tooltip.m_257550_((Component)SoundSouceInit.TOOLTIPS.getOrDefault(category, CommonComponents.f_237098_)), ((Double)simpleOption.m_231551_() == 1.0 ? 1 : 0) != 0, value -> simpleOption.m_231514_((Object)(value != false ? 1.0 : 0.0)));
        }
        return simpleOption;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class SoundEntry
    extends ContainerObjectSelectionList.Entry<SoundEntry> {
        List<? extends AbstractWidget> widgets;

        public SoundEntry(List<? extends AbstractWidget> w) {
            this.widgets = w;
        }

        public static SoundEntry create(Options options, int width, OptionInstance<?> simpleOption) {
            return new SoundEntry(List.of(simpleOption.m_231507_(options, width / 2 - 155, 0, 310)));
        }

        public static SoundEntry createDouble(Options options, int width, OptionInstance<?> first, @Nullable OptionInstance<?> second) {
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            widgets.add(first.m_231507_(options, width / 2 - 155, 0, 150));
            if (second != null) {
                widgets.add(second.m_231507_(options, width / 2 + 5, 0, 150));
            }
            return new SoundEntry(widgets);
        }

        public static SoundEntry createGroup(Options options, OptionInstance<?> group, int width, Button.OnPress pressAction) {
            return new SoundEntry(List.of(group.m_231507_(options, width / 2 - 155, 0, 285), new ImageButton(width / 2 + 135, 0, 20, 20, 0, 0, 20, ExtraSoundsNext.SETTINGS_ICON, 20, 40, pressAction)));
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.widgets;
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            return this.widgets;
        }

        public void m_6311_(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.widgets.forEach(s -> {
                s.m_253211_(y);
                s.m_88315_(context, mouseX, mouseY, tickDelta);
            });
        }
    }
}

