/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.IRegistryDataLoader;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.JsonHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.SwordRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ToolRegistry;
import org.apache.logging.log4j.util.Supplier;

public class RegistryLoader
extends SimpleJsonResourceReloadListener {
    private static final Map<String, IRegistryDataLoader> loaders = new HashMap<String, IRegistryDataLoader>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<ResourceLocation, String> loadedRegistries = new HashMap<ResourceLocation, String>();
    private final List<DependentFile> loadLater = new ArrayList<DependentFile>();

    public static void registerParser(IRegistryDataLoader parser) {
        loaders.put(parser.getName(), parser);
    }

    public RegistryLoader() {
        super(GSON, "registry");
    }

    protected void apply(Map<ResourceLocation, JsonElement> registries, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        loaders.values().forEach(IRegistryDataLoader::clear);
        registries.forEach(this::loadRegistry);
        this.loadDependents(registries);
    }

    private void loadDependents(Map<ResourceLocation, JsonElement> registries) {
        int lastCountLoadLater = this.loadLater.size();
        while (!this.loadLater.isEmpty()) {
            Iterator<DependentFile> iterator = this.loadLater.iterator();
            while (iterator.hasNext()) {
                DependentFile dependentFile = iterator.next();
                if (!this.areDependenciesLoaded(dependentFile.getDependencies())) continue;
                this.loadRegistry(dependentFile.getName(), registries.get(dependentFile.getName()));
                iterator.remove();
            }
            if (lastCountLoadLater <= this.loadLater.size()) {
                this.logIncorrectDependencies();
                break;
            }
            lastCountLoadLater = this.loadLater.size();
        }
    }

    private void logIncorrectDependencies() {
        for (DependentFile dependentFile : this.loadLater) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = dependentFile::getName;
            supplierArray[1] = () -> String.join((CharSequence)",", dependentFile.getDependencies());
            SophisticatedBackpacks.LOGGER.error("Non existent or circular load after dependencies in {} - {}", supplierArray);
        }
    }

    private void loadRegistry(ResourceLocation name, JsonElement fullJson) {
        Set<String> dependencies;
        SophisticatedBackpacks.LOGGER.debug("Started loading registry data from {} ", (Object)name);
        String path = name.m_135815_();
        String shortName = path.substring(path.lastIndexOf(47) + 1);
        if (!fullJson.isJsonObject()) {
            return;
        }
        JsonObject json = fullJson.getAsJsonObject();
        Optional<IRegistryDataLoader> loader = this.getLoader(shortName, json);
        if (loader.isEmpty()) {
            SophisticatedBackpacks.LOGGER.error("No loader defined for {}", (Object)shortName);
            return;
        }
        if (json.has("load_after") && !this.areDependenciesLoaded(dependencies = JsonHelper.setFromJson(json.get("load_after"), e -> GsonHelper.m_13805_((JsonElement)e, (String)"")))) {
            this.loadLater.add(new DependentFile(name, dependencies));
            SophisticatedBackpacks.LOGGER.debug("Registry data at {} depend on {} which are not all loaded, skipping for now.", (Object)name, dependencies);
            return;
        }
        this.loadedRegistries.put(name, loader.get().getName());
        String modId = null;
        if (GsonHelper.m_13900_((JsonObject)json, (String)"mod")) {
            modId = GsonHelper.m_13906_((JsonObject)json, (String)"mod");
        }
        if (this.isDisabled(json) || modId != null && !ModList.get().isLoaded(modId)) {
            return;
        }
        try {
            loader.get().parse(json, modId);
            SophisticatedBackpacks.LOGGER.debug("Finished loading registry data for {}", (Object)name);
        }
        catch (Exception exception) {
            SophisticatedBackpacks.LOGGER.error("Caught exception while loading {} : {}", (Object)name, (Object)exception);
        }
    }

    private boolean areDependenciesLoaded(Set<String> dependencies) {
        for (String dependency : dependencies) {
            if (this.loadedRegistries.containsValue(dependency)) continue;
            return false;
        }
        return true;
    }

    private boolean isDisabled(JsonObject json) {
        return json.has("disabled") && GsonHelper.m_13912_((JsonObject)json, (String)"disabled");
    }

    private Optional<IRegistryDataLoader> getLoader(String fileName, JsonObject json) {
        String parserName = fileName;
        if (json.has("type")) {
            parserName = GsonHelper.m_13906_((JsonObject)json, (String)"type");
        }
        return loaders.containsKey(parserName) ? Optional.of(loaders.get(parserName)) : Optional.empty();
    }

    static {
        RegistryLoader.registerParser(new ToolRegistry.BlockToolsLoader());
        RegistryLoader.registerParser(new ToolRegistry.EntityToolsLoader());
        RegistryLoader.registerParser(new SwordRegistry.SwordsLoader());
    }

    private static class DependentFile {
        private final ResourceLocation name;
        private final Set<String> dependencies;

        private DependentFile(ResourceLocation name, Set<String> dependencies) {
            this.name = name;
            this.dependencies = dependencies;
        }

        public Set<String> getDependencies() {
            return this.dependencies;
        }

        public ResourceLocation getName() {
            return this.name;
        }
    }
}

