/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.item;

import com.cyanogen.experienceobelisk.registries.RegisterSounds;
import com.cyanogen.experienceobelisk.utils.MiscUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ItemStackedOnOtherEvent;

public class NeurogelMendingItem
extends Item {
    public NeurogelMendingItem(Item.Properties p) {
        super(p);
    }

    public int maxRepairPoints() {
        return 320;
    }

    public double maxRepairPercentage() {
        return 0.25;
    }

    public static void handleItem(ItemStackedOnOtherEvent event) {
        ItemStack holding = event.getStackedOnItem();
        ItemStack itemToRepair = event.getCarriedItem();
        Player player = event.getPlayer();
        Item item = holding.m_41720_();
        if (item instanceof NeurogelMendingItem) {
            NeurogelMendingItem neurogel = (NeurogelMendingItem)item;
            if (itemToRepair.m_41768_()) {
                int maxDurability = itemToRepair.m_41776_();
                int damage = itemToRepair.m_41773_();
                int repairAmount = (int)Math.max((double)maxDurability * neurogel.maxRepairPercentage(), (double)neurogel.maxRepairPoints());
                holding.m_41774_(1);
                itemToRepair.m_41721_(Math.max(damage - repairAmount, 0));
                player.m_5496_((SoundEvent)RegisterSounds.NEUROGEL_APPLY.get(), 0.75f, MiscUtils.randomInRange(0.8f, 1.2f));
                event.setCanceled(true);
            } else if (itemToRepair.m_150930_(Items.f_42147_) || itemToRepair.m_150930_(Items.f_42148_)) {
                neurogel.handleAnvilItem(event.getSlot(), player, holding, itemToRepair, event);
            }
        }
    }

    public void handleAnvilItem(Slot slot, Player player, ItemStack stackedOn, ItemStack itemToRepair, ItemStackedOnOtherEvent event) {
        ItemStack result;
        stackedOn.m_41774_(1);
        player.m_5496_((SoundEvent)RegisterSounds.NEUROGEL_APPLY.get(), 0.75f, MiscUtils.randomInRange(0.8f, 1.2f));
        ItemStack itemStack = result = itemToRepair.m_150930_(Items.f_42147_) ? Items.f_42146_.m_7968_() : Items.f_42147_.m_7968_();
        if (itemToRepair.m_41613_() == 1) {
            slot.m_5852_(result);
        } else {
            player.m_36356_(result);
            itemToRepair.m_41774_(1);
        }
        event.setCanceled(true);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(context.m_8083_());
        if (player != null && (state.m_60713_(Blocks.f_50323_) || state.m_60713_(Blocks.f_50324_))) {
            BlockState anvil = Blocks.f_50322_.m_152465_(state);
            BlockState chipped = Blocks.f_50323_.m_152465_(state);
            if (state.m_60713_(Blocks.f_50323_)) {
                level.m_46597_(pos, anvil);
            } else if (state.m_60713_(Blocks.f_50324_)) {
                level.m_46597_(pos, chipped);
            }
            stack.m_41774_(1);
            player.m_5496_((SoundEvent)RegisterSounds.NEUROGEL_APPLY.get(), 0.75f, MiscUtils.randomInRange(0.8f, 1.2f));
            return InteractionResult.CONSUME;
        }
        return super.onItemUseFirst(stack, context);
    }
}

