/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities;

import com.cyanogen.experienceobelisk.block_entities.ExperienceReceivingEntity;
import com.cyanogen.experienceobelisk.config.Config;
import com.cyanogen.experienceobelisk.recipe.MolecularMetamorpherRecipe;
import com.cyanogen.experienceobelisk.registries.RegisterBlockEntities;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import com.cyanogen.experienceobelisk.registries.RegisterSounds;
import com.cyanogen.experienceobelisk.utils.RecipeUtils;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MolecularMetamorpherEntity
extends ExperienceReceivingEntity
implements GeoBlockEntity {
    boolean isProcessing = false;
    boolean busy = false;
    int processTime = 0;
    int processProgress = 0;
    int recipeCost = 0;
    ResourceLocation recipeId;
    private boolean lockInputs = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation ACTIVE = RawAnimation.begin().thenPlay("active");
    protected ItemStackHandler inputHandler = this.inputHandler();
    protected ItemStackHandler outputHandler = this.outputHandler();
    protected ItemStackHandler savedInputs = this.savedInputs();
    private final LazyOptional<IItemHandler> inputHandlerOptional = LazyOptional.of(() -> this.inputHandler);
    private final LazyOptional<IItemHandler> outputHandlerOptional = LazyOptional.of(() -> this.outputHandler);

    public MolecularMetamorpherEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.MOLECULAR_METAMORPHER_BE.get(), pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this::controller)});
    }

    protected <E extends MolecularMetamorpherEntity> PlayState controller(AnimationState<E> state) {
        MolecularMetamorpherEntity metamorpher = (MolecularMetamorpherEntity)state.getAnimatable();
        AnimationController controller = state.getController();
        RawAnimation animation = controller.getCurrentRawAnimation();
        if (animation == null) {
            controller.setAnimation(IDLE);
        } else if (metamorpher.busy && animation.equals((Object)IDLE)) {
            controller.setAnimation(ACTIVE);
        } else if (!metamorpher.busy && animation.equals((Object)ACTIVE)) {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof MolecularMetamorpherEntity) {
            MolecularMetamorpherEntity metamorpher = (MolecularMetamorpherEntity)((Object)blockEntity);
            boolean active = !metamorpher.redstoneEnabled || level.m_276867_(pos);
            metamorpher.sendObeliskInfoToScreen();
            if (metamorpher.isProcessing) {
                metamorpher.busy = true;
                if (metamorpher.processProgress >= metamorpher.processTime) {
                    metamorpher.dispenseResult();
                } else if (metamorpher.validateRecipe()) {
                    metamorpher.incrementProcessProgress();
                }
            } else {
                metamorpher.busy = active && metamorpher.hasContents() ? (metamorpher.handleJsonRecipes() ? true : metamorpher.handleNameFormattingRecipes()) : false;
            }
            if (metamorpher.busy) {
                metamorpher.handleAudio(level, pos);
            }
        }
    }

    public boolean hasContents() {
        boolean hasContents = false;
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.inputHandler.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_().equals(Items.f_41852_)) continue;
            hasContents = true;
            break;
        }
        return hasContents;
    }

    public void handleAudio(Level level, BlockPos pos) {
        int period = 15;
        long time = level.m_46467_();
        if (time % (long)period == 0L) {
            level.m_5594_(null, pos, (SoundEvent)RegisterSounds.METAMORPHER_BUSY1.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
        } else if (time % (long)period == (long)(period / 2)) {
            level.m_5594_(null, pos, (SoundEvent)RegisterSounds.METAMORPHER_BUSY2.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
        }
    }

    public ItemStackHandler inputHandler() {
        return new ItemStackHandler(3);
    }

    public ItemStackHandler outputHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return false;
            }
        };
    }

    public ItemStackHandler savedInputs() {
        return new ItemStackHandler(3){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }

            protected void onContentsChanged(int slot) {
                MolecularMetamorpherEntity.this.m_6596_();
                super.onContentsChanged(slot);
            }
        };
    }

    public ItemStackHandler getInputHandler() {
        return this.inputHandler;
    }

    public ItemStackHandler getOutputHandler() {
        return this.outputHandler;
    }

    public ItemStackHandler getSavedInputs() {
        return this.savedInputs;
    }

    public boolean isEmpty() {
        return this.inputsAreEmpty() && this.outputHandler.getStackInSlot(0).m_41619_();
    }

    public boolean inputsAreEmpty() {
        return this.inputHandler.getStackInSlot(0).m_41619_() && this.inputHandler.getStackInSlot(1).m_41619_() && this.inputHandler.getStackInSlot(2).m_41619_();
    }

    public boolean inputsAreLocked() {
        return this.lockInputs;
    }

    public void lockInputs(boolean lock) {
        this.lockInputs = lock;
        for (int i = 0; i < 3; ++i) {
            if (lock) {
                this.savedInputs.setStackInSlot(i, this.inputHandler.getStackInSlot(i).m_41777_());
                continue;
            }
            this.savedInputs.setStackInSlot(i, ItemStack.f_41583_);
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
        this.m_6596_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.DOWN) {
                return this.outputHandlerOptional.cast();
            }
            if (facing != Direction.UP) {
                return this.inputHandlerOptional.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        this.inputHandlerOptional.invalidate();
        this.outputHandlerOptional.invalidate();
        super.invalidateCaps();
    }

    public boolean handleJsonRecipes() {
        int cost;
        MolecularMetamorpherRecipe recipe;
        ItemStack output;
        if (this.getRecipe().isPresent() && this.canPerformRecipe(output = (recipe = this.getRecipe().get()).assemble(this.getSimpleContainer(), this.f_58857_ == null ? null : this.f_58857_.m_9598_()), cost = recipe.getCost())) {
            this.initiateRecipe(recipe);
            return true;
        }
        return false;
    }

    public boolean canPerformRecipe(ItemStack output, int cost) {
        ItemStack stackInResults = this.outputHandler.getStackInSlot(0);
        return this.getBoundObelisk() != null && this.getBoundObelisk().getFluidAmount() >= cost * 20 && (ItemStack.m_150942_((ItemStack)stackInResults, (ItemStack)output) || stackInResults.m_41619_() || stackInResults.m_150930_(Items.f_41852_)) && stackInResults.m_41613_() <= output.m_41741_() - output.m_41613_();
    }

    public void initiateRecipe(MolecularMetamorpherRecipe recipe) {
        this.setProcessing(true);
        this.setRecipeId(recipe);
        this.setProcessProgress(0);
        this.setProcessTime(recipe.getProcessTime());
        this.setRecipeCost(recipe.getCost());
        this.getBoundObelisk().drain(recipe.getCost() * 20);
    }

    public boolean validateRecipe() {
        boolean hasValidJsonRecipe;
        boolean bl = hasValidJsonRecipe = this.getRecipe().isPresent() && this.getRecipe().get().m_6423_().equals((Object)this.recipeId);
        if (hasValidJsonRecipe || this.hasNameFormattingRecipe()) {
            return true;
        }
        if (this.getBoundObelisk() != null) {
            this.getBoundObelisk().fill(20 * this.recipeCost);
        }
        this.setProcessing(false);
        this.resetAll();
        return false;
    }

    public SimpleContainer deplete(MolecularMetamorpherRecipe recipe) {
        SimpleContainer container = this.getSimpleContainer();
        block0: for (int j = 1; j <= 3; ++j) {
            Ingredient ingredient = (Ingredient)recipe.getIngredients(true).get(j).m_14418_();
            int count = (Integer)recipe.getIngredients(true).get(j).m_14419_();
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!ingredient.test(stack)) continue;
                if (stack.m_150930_((Item)RegisterItems.TRANSFORMING_FOCUS.get())) {
                    if (stack.m_41773_() >= 511 || recipe.isNameFormatting()) {
                        stack.m_41774_(1);
                        continue block0;
                    }
                    stack.m_220157_(1, RandomSource.m_216327_(), null);
                    continue block0;
                }
                if (stack.hasCraftingRemainingItem()) {
                    container.m_6836_(i, stack.getCraftingRemainingItem());
                    continue block0;
                }
                if (stack.m_41613_() >= count) {
                    stack.m_41774_(count);
                    continue block0;
                }
                count -= stack.m_41613_();
                stack.m_41774_(stack.m_41613_());
            }
        }
        return container;
    }

    public void dispenseResult() {
        this.setProcessing(false);
        Optional optional = this.f_58857_.m_7465_().m_44043_(this.recipeId);
        MolecularMetamorpherRecipe recipe = null;
        if (optional.isPresent() && optional.get() instanceof MolecularMetamorpherRecipe) {
            recipe = (MolecularMetamorpherRecipe)optional.get();
        } else if (this.hasNameFormattingRecipe()) {
            recipe = this.getNameFormattingRecipe();
        }
        if (recipe != null) {
            ItemStack result = recipe.m_8043_(null);
            ItemStack stackInResults = this.outputHandler.getStackInSlot(0).m_41777_();
            SimpleContainer remainders = this.deplete(recipe);
            int count = result.m_41613_();
            if (ItemStack.m_150942_((ItemStack)result, (ItemStack)stackInResults)) {
                stackInResults.m_41769_(count);
                this.outputHandler.setStackInSlot(0, stackInResults);
            } else {
                this.outputHandler.setStackInSlot(0, result);
            }
            for (int i = 0; i < 3; ++i) {
                this.inputHandler.setStackInSlot(i, remainders.m_8020_(i));
            }
        }
        this.resetAll();
    }

    public boolean handleNameFormattingRecipes() {
        int cost;
        MolecularMetamorpherRecipe recipe;
        ItemStack output;
        if (((Boolean)Config.COMMON.formatting.get()).booleanValue() && this.hasNameFormattingRecipe() && this.canPerformRecipe(output = (recipe = this.getNameFormattingRecipe()).m_8043_(null), cost = recipe.getCost())) {
            this.initiateRecipe(recipe);
            return true;
        }
        return false;
    }

    public boolean hasNameFormattingRecipe() {
        Item formatItem = this.inputHandler.getStackInSlot(2).m_41720_();
        return !this.inputHandler.getStackInSlot(0).m_41619_() && this.inputHandler.getStackInSlot(1).m_150930_(Items.f_42656_) && (formatItem instanceof DyeItem || RecipeUtils.getValidFormattingItems().contains(formatItem));
    }

    public MolecularMetamorpherRecipe getNameFormattingRecipe() {
        int index;
        char code;
        ChatFormatting format;
        ItemStack inputItem = this.inputHandler.getStackInSlot(0);
        ItemStack nameTag = this.inputHandler.getStackInSlot(1);
        ItemStack formatStack = this.inputHandler.getStackInSlot(2);
        Item formatItem = formatStack.m_41720_();
        MutableComponent name = inputItem.m_41786_().m_6881_();
        if (RecipeUtils.getValidDyes().contains(formatItem)) {
            DyeItem dye = (DyeItem)formatItem;
            int dyeColor = dye.m_41089_().m_41060_();
            format = ChatFormatting.m_126647_((int)RecipeUtils.dyeColorToTextColor(dyeColor));
            if (format != null) {
                name = name.m_130940_(format);
            }
        } else if (RecipeUtils.getValidFormattingItems().contains(formatItem) && (format = ChatFormatting.m_126645_((char)(code = RecipeUtils.itemToFormat(index = RecipeUtils.getValidFormattingItems().indexOf(formatItem))))) != null) {
            name = name.m_130940_(format);
        }
        ArrayList<Tuple<Ingredient, Integer>> ingredients = MolecularMetamorpherRecipe.assembleIngredients(Ingredient.m_43927_((ItemStack[])new ItemStack[]{inputItem.m_41777_()}), inputItem.m_41613_(), Ingredient.m_43927_((ItemStack[])new ItemStack[]{nameTag.m_41777_()}), nameTag.m_41613_(), Ingredient.m_43927_((ItemStack[])new ItemStack[]{formatStack.m_41777_()}), formatStack.m_41613_());
        ItemStack output = inputItem.m_41777_().m_41714_((Component)name);
        int cost = 315;
        int processTime = 60;
        return new MolecularMetamorpherRecipe(ingredients, output, cost, processTime, new ResourceLocation("experienceobelisk", "item_name_formatting"));
    }

    public Optional<MolecularMetamorpherRecipe> getRecipe() {
        return this.f_58857_.m_7465_().m_44015_((RecipeType)MolecularMetamorpherRecipe.Type.INSTANCE, (Container)this.getSimpleContainer(), this.f_58857_);
    }

    public SimpleContainer getSimpleContainer() {
        SimpleContainer container = new SimpleContainer(3);
        container.m_6836_(0, this.inputHandler.getStackInSlot(0).m_41777_());
        container.m_6836_(1, this.inputHandler.getStackInSlot(1).m_41777_());
        container.m_6836_(2, this.inputHandler.getStackInSlot(2).m_41777_());
        return container;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public void setProcessing(boolean isProcessing) {
        this.isProcessing = isProcessing;
        this.m_6596_();
    }

    public boolean isBusy() {
        return this.busy;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public void setProcessTime(int time) {
        this.processTime = time;
        this.m_6596_();
    }

    public int getProcessProgress() {
        return this.processProgress;
    }

    public void setProcessProgress(int progress) {
        this.processProgress = progress;
        this.m_6596_();
    }

    public void incrementProcessProgress() {
        ++this.processProgress;
        this.m_6596_();
    }

    public void setRecipeId(MolecularMetamorpherRecipe recipe) {
        this.recipeId = recipe.m_6423_();
        this.m_6596_();
    }

    public void setRecipeCost(int cost) {
        this.recipeCost = cost;
        this.m_6596_();
    }

    public void resetAll() {
        this.processProgress = 0;
        this.processTime = 0;
        this.recipeId = null;
        this.recipeCost = 0;
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
        super.m_6596_();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputHandler.deserializeNBT(tag.m_128469_("Inputs"));
        this.outputHandler.deserializeNBT(tag.m_128469_("Outputs"));
        this.isProcessing = tag.m_128471_("IsProcessing");
        this.processTime = tag.m_128451_("ProcessTime");
        this.processProgress = tag.m_128451_("ProcessProgress");
        this.recipeId = new ResourceLocation(tag.m_128461_("RecipeID"));
        this.recipeCost = tag.m_128451_("RecipeCost");
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inputs", (Tag)this.inputHandler.serializeNBT());
        tag.m_128365_("Outputs", (Tag)this.outputHandler.serializeNBT());
        tag.m_128379_("IsProcessing", this.isProcessing);
        tag.m_128405_("ProcessTime", this.processTime);
        tag.m_128405_("ProcessProgress", this.processProgress);
        tag.m_128405_("RecipeCost", this.recipeCost);
        if (this.recipeId != null) {
            tag.m_128359_("RecipeID", this.recipeId.toString());
        }
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("Inputs", (Tag)this.inputHandler.serializeNBT());
        tag.m_128365_("Outputs", (Tag)this.outputHandler.serializeNBT());
        tag.m_128379_("IsProcessing", this.isProcessing);
        tag.m_128405_("ProcessTime", this.processTime);
        tag.m_128405_("ProcessProgress", this.processProgress);
        tag.m_128405_("RecipeCost", this.recipeCost);
        if (this.recipeId != null) {
            tag.m_128359_("RecipeID", this.recipeId.toString());
        }
        return tag;
    }
}

