/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.item;

import com.enderio.core.client.item.ItemBarRenderer;
import com.enderio.core.common.util.EnergyUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.IItemDecorator;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class EnergyBarDecorator
implements IItemDecorator {
    public static final EnergyBarDecorator INSTANCE = new EnergyBarDecorator();
    public static final int BAR_COLOR = 11626724;

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        if (EnergyUtil.getMaxEnergyStored(stack) <= 0) {
            return false;
        }
        float fillRatio = stack.getCapability(ForgeCapabilities.ENERGY).map(energyStorage -> Float.valueOf(1.0f - (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored())).orElse(Float.valueOf(0.0f)).floatValue();
        ItemBarRenderer.renderBar(guiGraphics, fillRatio, xOffset, yOffset, 0, 11626724);
        return false;
    }
}

