/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.tool;

import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.item.tool.PoweredToggledItem;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.common.util.AttractionUtil;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ElectromagnetItem
extends PoweredToggledItem {
    private static final double COLLISION_DISTANCE_SQ = 1.5625;
    private static final double SPEED = 0.035;
    private static final double SPEED_4 = 0.14;

    public ElectromagnetItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    protected int getEnergyUse() {
        return (Integer)BaseConfig.COMMON.ITEMS.ELECTROMAGNET_ENERGY_USE.get();
    }

    @Override
    protected int getMaxEnergy() {
        return (Integer)BaseConfig.COMMON.ITEMS.ELECTROMAGNET_MAX_ENERGY.get();
    }

    private int getRange() {
        return (Integer)BaseConfig.COMMON.ITEMS.ELECTROMAGNET_RANGE.get();
    }

    private int getMaxItems() {
        return (Integer)BaseConfig.COMMON.ITEMS.ELECTROMAGNET_MAX_ITEMS.get();
    }

    private boolean isBlacklisted(ItemEntity entity) {
        return entity.m_32055_().m_204117_(EIOTags.Items.ELECTROMAGNET_BLACKLIST);
    }

    private boolean isMagnetable(Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return !this.isBlacklisted(itemEntity);
        }
        return entity instanceof ExperienceOrb;
    }

    @Override
    protected void onTickWhenActive(Player player, ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (player.m_5833_()) {
            return;
        }
        int range = this.getRange();
        AABB bounds = new AABB(player.m_20185_() - (double)range, player.m_20186_() - (double)range, player.m_20189_() - (double)range, player.m_20185_() + (double)range, player.m_20186_() + (double)range, player.m_20189_() + (double)range);
        List toMove = pLevel.m_6249_((Entity)player, bounds, this::isMagnetable);
        int itemsRemaining = this.getMaxItems();
        if (itemsRemaining <= 0) {
            itemsRemaining = Integer.MAX_VALUE;
        }
        for (Entity entity : toMove) {
            if (AttractionUtil.moveToPos(pEntity, player.m_20185_(), player.m_20186_() + (double)(player.m_20192_() * 0.75f), player.m_20189_(), 0.035, 0.14, 1.5625)) {
                entity.m_6123_(player);
            }
            if (itemsRemaining-- > 0) continue;
            return;
        }
    }
}

