/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.registry;

import com.github.jarva.arsartifice.ArsArtifice;
import com.github.jarva.arsartifice.item.ArtificerCurio;
import com.github.jarva.arsartifice.item.SpellGem;
import com.github.jarva.arsartifice.recipes.NoDamageEnchantmentRecipe;
import com.github.jarva.arsartifice.registry.AddonBlockRegistry;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class ModRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ars_artifice");
    public static final DeferredRegister<RecipeType<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"ars_artifice");
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"ars_artifice");
    public static final RegistryObject<Item> SPELL_STORING_RING = ITEMS.register("spell_storing_ring", ArtificerCurio::new);
    public static final RegistryObject<Item> SPELL_STORING_AMULET = ITEMS.register("spell_storing_amulet", ArtificerCurio::new);
    public static final RegistryObject<Item> SPELL_STORING_BELT = ITEMS.register("spell_storing_belt", ArtificerCurio::new);
    public static final RegistryObject<Item> SPELL_GEM_1 = ITEMS.register("spell_gem_t1", () -> new SpellGem(250));
    public static final RegistryObject<Item> SPELL_GEM_2 = ITEMS.register("spell_gem_t2", () -> new SpellGem(500));
    public static final RegistryObject<Item> SPELL_GEM_3 = ITEMS.register("spell_gem_t3", () -> new SpellGem(1000));
    public static final String NO_DAMAGE_RECIPE_ID = "no_damage_enchantment";
    public static final RegistryObject<RecipeType<NoDamageEnchantmentRecipe>> NO_DAMAGE_TYPE = RECIPES.register("no_damage_enchantment", () -> RecipeType.simple((ResourceLocation)ArsArtifice.prefix(NO_DAMAGE_RECIPE_ID)));
    public static final RegistryObject<RecipeSerializer<NoDamageEnchantmentRecipe>> NO_DAMAGE_RECIPE = SERIALIZERS.register("no_damage_enchantment", NoDamageEnchantmentRecipe.Serializer::new);

    public static void registerRegistries(IEventBus bus) {
        AddonBlockRegistry.BLOCKS.register(bus);
        AddonBlockRegistry.BLOCK_ENTITIES.register(bus);
        RECIPES.register(bus);
        SERIALIZERS.register(bus);
        ITEMS.register(bus);
    }

    public static void registerEvents(RegisterEvent event) {
        IForgeRegistry registry;
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCKS)) {
            registry = Objects.requireNonNull(event.getForgeRegistry());
            AddonBlockRegistry.onBlocksRegistry((IForgeRegistry<Block>)registry);
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
            registry = Objects.requireNonNull(event.getForgeRegistry());
            AddonBlockRegistry.onBlockItemsRegistry((IForgeRegistry<Item>)registry);
        }
    }
}

