/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.glyphs;

import com.github.jarva.arsartifice.ArsArtifice;
import com.github.jarva.arsartifice.glyphs.AbstractArtificeMethod;
import com.github.jarva.arsartifice.item.ArtificerCurio;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="ars_artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AnguishArtificeMethod
extends AbstractArtificeMethod {
    public static AnguishArtificeMethod INSTANCE = new AnguishArtificeMethod(ArsArtifice.prefix("glyph_anguish"), "Anguish");
    public ForgeConfigSpec.IntValue THRESHOLD;
    public ForgeConfigSpec.IntValue STEP;

    public AnguishArtificeMethod(ResourceLocation tag, String description) {
        super(tag, description);
    }

    public String getBookDescription() {
        return "Anguish triggers when you take damage. Amplify increases the required damage to trigger. Dampen reduces the required damage to trigger.";
    }

    public int getDefaultManaCost() {
        return 0;
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.THRESHOLD = builder.comment("Damage threshold, in half-hearts").defineInRange("threshold", 6, 1, Integer.MAX_VALUE);
        this.STEP = builder.comment("Damage threshold step, in half-hearts").defineInRange("step", 2, 1, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE});
    }

    public double getDamageThreshold(double amplifier) {
        return (double)((Integer)this.THRESHOLD.get()).intValue() + amplifier * (double)((Integer)this.STEP.get()).intValue();
    }

    @SubscribeEvent
    public static void onEntityDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Optional curios = CuriosApi.getCuriosInventory((LivingEntity)entity).resolve();
        curios.ifPresent(curiosHandler -> {
            IItemHandlerModifiable handler = curiosHandler.getEquippedCurios();
            for (int i = 0; i < handler.getSlots(); ++i) {
                SpellStats stats;
                AnguishArtificeMethod retaliateMethod;
                AbstractArtificeMethod method;
                Object patt3537$temp;
                ArtificerCurio.ArtificerCaster caster;
                Spell artifice;
                ItemStack item = handler.getStackInSlot(i);
                if (!(item.m_41720_() instanceof ArtificerCurio) || (artifice = (caster = new ArtificerCurio.ArtificerCaster(item)).getSpell(0)).isEmpty() || !((patt3537$temp = artifice.recipe.get(0)) instanceof AbstractArtificeMethod) || !((method = (AbstractArtificeMethod)((Object)((Object)patt3537$temp))) instanceof AnguishArtificeMethod) || !((retaliateMethod = (AnguishArtificeMethod)method).getDamageThreshold((stats = retaliateMethod.getSpellStats((ISpellCaster)caster, entity, artifice)).getAmpMultiplier()) <= (double)event.getAmount())) continue;
                caster.castSpell(entity.m_9236_(), entity, InteractionHand.MAIN_HAND, (Component)Component.m_237115_((String)"ars_nouveau.spell.validation.crafting.invalid"), caster.getSpell(1));
            }
        });
    }

    @Override
    public Component getMeta(HashMap<AbstractAugment, Integer> augments) {
        double amp = this.getAmpMultiplier(augments);
        return this.format(this.getDamageThreshold(amp), "damage");
    }
}

