/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.datagen;

import com.github.jarva.arsartifice.ArsNouveauRegistry;
import com.github.jarva.arsartifice.datagen.Setup;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.CraftingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EnchantingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EntityPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.GlyphScribePage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ImbuementPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public class PatchouliProvider
extends com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider {
    public PatchouliProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        for (AbstractSpellPart spell : ArsNouveauRegistry.registeredSpells) {
            this.addGlyphPage(spell);
        }
        for (PatchouliProvider.PatchouliPage patchouliPage : this.pages) {
            this.saveStable(cache, (JsonElement)patchouliPage.build(), patchouliPage.path());
        }
    }

    public PatchouliProvider.PatchouliPage addBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = new PatchouliBuilder(category, item.m_5456_().m_5524_()).withIcon((ItemLike)item.m_5456_()).withPage((IPatchouliPage)new TextPage(Setup.root + ".page." + RegistryHelper.getRegistryName((Item)item.m_5456_()).m_135815_())).withPage(recipePage);
        PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(category, RegistryHelper.getRegistryName((Item)item.m_5456_()).m_135815_()));
        this.pages.add(page);
        return page;
    }

    public void addFamiliarPage(AbstractFamiliarHolder familiarHolder) {
        PatchouliBuilder builder = new PatchouliBuilder(FAMILIARS, "entity." + Setup.root + "." + familiarHolder.getRegistryName().m_135815_()).withIcon(Setup.root + ":" + familiarHolder.getRegistryName().m_135815_()).withTextPage(Setup.root + ".familiar_desc." + familiarHolder.getRegistryName().m_135815_()).withPage((IPatchouliPage)new EntityPage(familiarHolder.getRegistryName().toString()));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(FAMILIARS, familiarHolder.getRegistryName().m_135815_())));
    }

    public void addRitualPage(AbstractRitual ritual) {
        PatchouliBuilder builder = new PatchouliBuilder(RITUALS, "item." + Setup.root + "." + ritual.getRegistryName().m_135815_()).withIcon(ritual.getRegistryName().toString()).withTextPage(ritual.getDescriptionKey()).withPage((IPatchouliPage)new CraftingPage(Setup.root + ":tablet_" + ritual.getRegistryName().m_135815_()));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(RITUALS, ritual.getRegistryName().m_135815_())));
    }

    public void addEnchantmentPage(Enchantment enchantment) {
        PatchouliBuilder builder = new PatchouliBuilder(ENCHANTMENTS, enchantment.m_44704_()).withIcon(RegistryHelper.getRegistryName((Item)Items.f_42690_).toString()).withTextPage(Setup.root + ".enchantment_desc." + RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_());
        for (int i = enchantment.m_44702_(); i <= enchantment.m_6586_(); ++i) {
            builder.withPage((IPatchouliPage)new EnchantingPage(Setup.root + ":" + RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_() + "_" + i));
        }
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(ENCHANTMENTS, RegistryHelper.getRegistryName((Enchantment)enchantment).m_135815_())));
    }

    public void addGlyphPage(AbstractSpellPart spellPart) {
        ResourceLocation category = switch (spellPart.defaultTier().value) {
            case 1 -> GLYPHS_1;
            case 2 -> GLYPHS_2;
            default -> GLYPHS_3;
        };
        PatchouliBuilder builder = new PatchouliBuilder(category, spellPart.getName()).withName(Setup.root + ".glyph_name." + spellPart.getRegistryName().m_135815_()).withIcon(spellPart.getRegistryName().toString()).withSortNum(spellPart instanceof AbstractCastMethod ? 1 : (spellPart instanceof AbstractEffect ? 2 : 3)).withPage((IPatchouliPage)new TextPage(Setup.root + ".glyph_desc." + spellPart.getRegistryName().m_135815_())).withPage((IPatchouliPage)new GlyphScribePage(spellPart));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(category, spellPart.getRegistryName().m_135815_())));
    }

    public Path getPath(ResourceLocation category, String fileName) {
        return this.output.resolve("assets/" + Setup.root + "/patchouli_books/example/en_us/entries/" + category.m_135815_() + "/" + fileName + ".json");
    }

    ImbuementPage ImbuementPage(ItemLike item) {
        return new ImbuementPage(Setup.root + ":imbuement_" + RegistryHelper.getRegistryName((Item)item.m_5456_()).m_135815_());
    }
}

