/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.util;

import de.geheimagentnr1.manyideas_core.elements.block_state_properties.Color;
import de.geheimagentnr1.manyideas_core.elements.block_state_properties.ModBlockStateProperties;
import de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.dyed.DyeBlock;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class DyeBlockHelper {
    @NotNull
    private static final String dyeNBTname = "dye";
    @NotNull
    private static final String colorNBTname = "color";

    private static String getColorNameFromStack(@NotNull ItemStack stack) {
        return stack.m_41698_(dyeNBTname).m_128461_(colorNBTname);
    }

    @NotNull
    public static String getColorName(@NotNull ItemStack stack) {
        String color = DyeBlockHelper.getColorNameFromStack(stack);
        return color.isEmpty() ? Color.WHITE.m_7912_() : color;
    }

    @NotNull
    public static Color getColor(@NotNull ItemStack stack) {
        String colorName = DyeBlockHelper.getColorName(stack);
        if (colorName.isEmpty()) {
            return Color.WHITE;
        }
        Color resultColor = Color.WHITE;
        for (Color color : Color.values()) {
            if (!color.m_7912_().equals(colorName)) continue;
            resultColor = color;
            break;
        }
        return resultColor;
    }

    @NotNull
    public static ItemStack setColorToItemStack(@NotNull ItemStack stack, @NotNull Color color) {
        stack.m_41698_(dyeNBTname).m_128359_(colorNBTname, color.m_7912_());
        return stack;
    }

    @NotNull
    public static BlockState getStateForPlacement(@NotNull DyeBlock block, @NotNull BlockPlaceContext context) {
        return (BlockState)block.m_49966_().m_61124_(ModBlockStateProperties.COLOR, (Comparable)((Object)DyeBlockHelper.getColor(context.m_43722_())));
    }

    public static void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ModBlockStateProperties.COLOR});
    }

    @NotNull
    public static ItemStack getItem(@NotNull DyeBlock block, @NotNull BlockState state) {
        return DyeBlockHelper.setColorToItemStack(new ItemStack((ItemLike)block), (Color)((Object)state.m_61143_(ModBlockStateProperties.COLOR)));
    }

    @NotNull
    public static ItemStack createItemStackOfItem(@NotNull Item item, @NotNull Color color) {
        return DyeBlockHelper.setColorToItemStack(new ItemStack((ItemLike)item), color);
    }
}

