/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.geheimagentnr1.minecraft_forge_api.elements.commands.CommandInterface;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

class ElementCountCommand
implements CommandInterface {
    ElementCountCommand() {
    }

    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder elementCountCommand = Commands.m_82127_((String)"element_count");
        elementCountCommand.executes(command -> {
            TreeSet<String> names = new TreeSet<String>();
            TreeMap<String, Integer> block_item_counts = new TreeMap<String, Integer>();
            TreeMap<String, Integer> item_counts = new TreeMap<String, Integer>();
            TreeMap<String, Integer> block_counts = this.countBlocks(names);
            this.countItems(names, item_counts, block_item_counts);
            for (String name : names) {
                ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)name), false);
                ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)("block count: " + block_counts.get(name))), false);
                ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)("block item count: " + block_item_counts.get(name))), false);
                ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237113_((String)("item count: " + item_counts.get(name))), false);
            }
            return 1;
        });
        return elementCountCommand;
    }

    private void countItems(@NotNull TreeSet<String> names, @NotNull TreeMap<String, Integer> item_counts, @NotNull TreeMap<String, Integer> block_item_counts) {
        for (Item item : BuiltInRegistries.f_257033_) {
            if (item instanceof BlockItem) {
                this.addElementToTreeMap((Object)item, (Registry)BuiltInRegistries.f_257033_, names, block_item_counts);
                continue;
            }
            this.addElementToTreeMap((Object)item, (Registry)BuiltInRegistries.f_257033_, names, item_counts);
        }
    }

    @NotNull
    private TreeMap<String, Integer> countBlocks(@NotNull TreeSet<String> names) {
        TreeMap<String, Integer> block_counts = new TreeMap<String, Integer>();
        for (Block block : BuiltInRegistries.f_256975_) {
            this.addElementToTreeMap((Object)block, (Registry)BuiltInRegistries.f_256975_, names, block_counts);
        }
        return block_counts;
    }

    private <T> void addElementToTreeMap(@NotNull T element, @NotNull Registry<T> registry, @NotNull TreeSet<String> names, @NotNull TreeMap<String, Integer> counts) {
        ResourceLocation resourceLocation = registry.m_7981_(element);
        if (resourceLocation != null) {
            Integer block_count = counts.get(resourceLocation.m_135827_());
            if (block_count == null) {
                names.add(resourceLocation.m_135827_());
            }
            block_count = block_count == null ? 0 : block_count;
            counts.put(resourceLocation.m_135827_(), block_count + 1);
        }
    }
}

