/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.blocks.table_saws;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.geheimagentnr1.manyideas_core.elements.blocks.table_saws.TableSawInputContainer;
import de.geheimagentnr1.manyideas_core.elements.blocks.table_saws.TableSawOutputSlot;
import de.geheimagentnr1.manyideas_core.elements.blocks.table_saws.TableSawRecipe;
import java.util.HashSet;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class TableSawMenu
extends AbstractContainerMenu {
    @NotNull
    private final ImmutableList<Item> ACCEPTED_INPUT_ITEMS;
    @NotNull
    private final ContainerLevelAccess containerLevelAccess;
    @NotNull
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    @NotNull
    private final Level level;
    @NotNull
    private List<TableSawRecipe> recipes = Lists.newArrayList();
    @NotNull
    private ItemStack itemStackInput = ItemStack.f_41583_;
    long lastOnTake;
    @NotNull
    private final Slot inputInventorySlot;
    @NotNull
    private final Slot outputInventorySlot;
    @NotNull
    private Runnable inventoryUpdateListener = () -> {};
    @NotNull
    private final Container inputInventory = new TableSawInputContainer(this);
    @NotNull
    private final ResultContainer resultContainer = new ResultContainer();

    protected TableSawMenu(@NotNull MenuType<? extends TableSawMenu> tableSawMenu, @NotNull int windowId, @NotNull Inventory inventory) {
        this(tableSawMenu, windowId, inventory, ContainerLevelAccess.f_39287_);
    }

    protected TableSawMenu(@NotNull MenuType<? extends TableSawMenu> tableSawMenu, int windowId, @NotNull Inventory inventory, @NotNull ContainerLevelAccess _containerLevelAccess) {
        super(tableSawMenu, windowId);
        this.containerLevelAccess = _containerLevelAccess;
        this.level = inventory.f_35978_.m_9236_();
        this.inputInventorySlot = this.m_38897_(new Slot(this.inputInventory, 0, 20, 33));
        this.outputInventorySlot = this.m_38897_(new TableSawOutputSlot(this, _containerLevelAccess, this.inputInventorySlot, (Container)this.resultContainer));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipe);
        HashSet acceptable_input = new HashSet();
        List<RecipeType<?>> acceptedRecipeTypes = this.getAcceptedRecipeTypes();
        this.level.m_7465_().m_44051_().forEach(iRecipe -> {
            if (acceptedRecipeTypes.contains(iRecipe.m_6671_())) {
                ItemStack[] itemStacks;
                TableSawRecipe tableSawRecipe = (TableSawRecipe)iRecipe;
                for (ItemStack itemStack : itemStacks = ((Ingredient)tableSawRecipe.m_7527_().get(0)).m_43908_()) {
                    acceptable_input.add(itemStack.m_41720_());
                }
            }
        });
        this.ACCEPTED_INPUT_ITEMS = ImmutableList.copyOf(acceptable_input);
    }

    @NotNull
    protected abstract List<RecipeType<?>> getAcceptedRecipeTypes();

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedRecipeIndex() {
        return this.selectedRecipe.m_6501_();
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public List<TableSawRecipe> getRecipes() {
        return this.recipes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getNumRecipes() {
        return this.recipes.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasInputItem() {
        return this.inputInventorySlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(@NotNull Player player) {
        return TableSawMenu.m_38889_((ContainerLevelAccess)this.containerLevelAccess, (Player)player, (Block)this.getCanInteractBlock());
    }

    protected abstract Block getCanInteractBlock();

    public boolean m_6366_(@NotNull Player player, int id) {
        if (id >= 0 && id < this.recipes.size()) {
            this.selectedRecipe.m_6422_(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    public void m_6199_(@NotNull Container container) {
        ItemStack itemstack = this.inputInventorySlot.m_7993_();
        if (itemstack.m_41720_() != this.itemStackInput.m_41720_()) {
            this.itemStackInput = itemstack.m_41777_();
            this.updateAvailableRecipes(container, itemstack);
        }
    }

    private void updateAvailableRecipes(@NotNull Container inventory, @NotNull ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.m_6422_(-1);
        this.outputInventorySlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = this.getAvaiableRecipes(inventory, this.level);
        }
    }

    @NotNull
    protected abstract List<TableSawRecipe> getAvaiableRecipes(@NotNull Container var1, @NotNull Level var2);

    void updateRecipeResultSlot() {
        if (this.recipes.isEmpty()) {
            this.outputInventorySlot.m_5852_(ItemStack.f_41583_);
        } else {
            TableSawRecipe tableSawRecipe = this.recipes.get(this.selectedRecipe.m_6501_());
            this.outputInventorySlot.m_5852_(tableSawRecipe.m_5874_(this.inputInventory, this.level.m_9598_()));
        }
        this.m_38946_();
    }

    @OnlyIn(value=Dist.CLIENT)
    void setInventoryUpdateListener(@NotNull Runnable listener) {
        this.inventoryUpdateListener = listener;
    }

    @NotNull
    Runnable getInventoryUpdateListener() {
        return this.inventoryUpdateListener;
    }

    public boolean m_5882_(@NotNull ItemStack stack, @NotNull Slot slot) {
        return false;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            itemstack = itemstack1.m_41777_();
            if (index == 1) {
                item.m_7836_(itemstack1, player.m_9236_(), player);
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index == 0 ? !this.m_38903_(itemstack1, 2, 38, false) : (this.ACCEPTED_INPUT_ITEMS.contains((Object)item) ? !this.m_38903_(itemstack1, 0, 1, false) : (index < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : index < 38 && !this.m_38903_(itemstack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.containerLevelAccess.m_39292_((levelIn, pos) -> this.m_150411_(player, this.inputInventory));
    }

    @NotNull
    public ResultContainer getResultContainer() {
        return this.resultContainer;
    }
}

