/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.util.client.particles.ball_particle;

import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.math.ComplexEasingFunction;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BallParticle
extends TextureSheetParticle {
    public static final ResourceLocation LOCATION = ResourceLocation.m_214293_((String)"fdlib", (String)"ball_particle");
    private BallParticleOptions options;
    private ComplexEasingFunction scalingFunction;
    private float quadSizeO;
    private float quadSizeC;
    private float maxQuadSize;
    public static final ParticleRenderType RENDER_TYPE = new ParticleRenderType(){

        @Nullable
        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.setShader(GameRenderer::m_172829_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118260_).setBlurMipmap(true, true);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
            Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118260_).restoreLastBlurMipmap();
        }

        public String toString() {
            return "fdlib:ball_particle";
        }
    };

    public BallParticle(BallParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.options = options;
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.f_107225_ = options.scalingOptions.fullTime();
        this.scalingFunction = ComplexEasingFunction.builder().addArea(options.scalingOptions.inTime, FDEasings::linear).addArea(options.scalingOptions.stayTime, FDEasings::one).addArea(options.scalingOptions.outTime, FDEasings::reversedLinear).build();
        this.f_172258_ = options.friction;
        this.f_107219_ = options.hasPhysics;
        this.maxQuadSize = options.size;
        this.quadSizeC = this.quadSizeO = this.scalingFunction.apply(0.0f) * this.maxQuadSize;
        this.f_107227_ = options.color.r;
        this.f_107228_ = options.color.g;
        this.f_107229_ = options.color.b;
        this.f_107230_ = options.color.a;
        options.particleProcessor.init((Particle)this);
    }

    public void m_5744_(VertexConsumer vertex, Camera camera, float pticks) {
        this.f_107663_ = FDMathUtil.lerp(this.quadSizeO, this.quadSizeC, pticks);
        for (int i = 0; i < Math.min(this.options.brightness, 30); ++i) {
            super.m_5744_(vertex, camera, pticks);
        }
    }

    public void m_5989_() {
        this.options.particleProcessor.processParticle((Particle)this);
        super.m_5989_();
        this.quadSizeO = this.quadSizeC;
        this.quadSizeC = this.scalingFunction.apply(this.f_107224_) * this.maxQuadSize;
    }

    protected int m_6355_(float pticks) {
        return 0xF000F0;
    }

    protected float m_5970_() {
        float v = super.m_5970_();
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        int w = engine.f_107296_.f_276067_;
        return v + 1.0f / (float)w;
    }

    protected float m_5952_() {
        float v = super.m_5952_();
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        int w = engine.f_107296_.f_276067_;
        return v - 1.0f / (float)w;
    }

    protected float m_5951_() {
        float v = super.m_5951_();
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        int w = engine.f_107296_.f_276070_;
        return v + 1.0f / (float)w;
    }

    protected float m_5950_() {
        float v = super.m_5950_();
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        int w = engine.f_107296_.f_276070_;
        return v - 1.0f / (float)w;
    }

    public ParticleRenderType m_7556_() {
        return RENDER_TYPE;
    }

    public static class Factory
    implements ParticleProvider<BallParticleOptions> {
        private SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(BallParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            BallParticle particle = new BallParticle(options, level, x, y, z, xd, yd, zd);
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }
}

