/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.simple_screen.fdwidgets;

import com.finderfeed.fdlib.systems.simple_screen.FDWidget;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.interfaces.OnFDWidgetClick;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.interfaces.OnFDWidgetHover;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.util.FDButtonTextures;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.util.WidgetTexture;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;

public class FDButton
extends FDWidget {
    protected OnFDWidgetClick click;
    protected OnFDWidgetHover hover;
    protected Component text;
    protected int textWidth;
    protected boolean textDrawShadow;
    protected float textScale;
    protected FDButtonTextures buttonTextures;
    protected float xTextOffset = 0.0f;
    protected float yTextOffset = 0.0f;
    protected SoundEvent sound;

    public FDButton(Screen screen, float x, float y, float width, float height) {
        super(screen, x, y, width, height);
    }

    public FDButton setSound(SoundEvent sound) {
        this.sound = sound;
        return this;
    }

    public FDButton setTexture(FDButtonTextures texture) {
        this.buttonTextures = texture;
        return this;
    }

    public FDButton setOnClickAction(OnFDWidgetClick click) {
        this.click = click;
        return this;
    }

    public FDButton setOnHoverAction(OnFDWidgetHover hoverAction) {
        this.hover = hoverAction;
        return this;
    }

    public FDButton setText(Component text, int textWidth, float textScale, boolean textDrawShadow, float xTextOffset, float yTextOffset) {
        this.text = text;
        this.textWidth = textWidth;
        this.textDrawShadow = textDrawShadow;
        this.textScale = textScale;
        this.xTextOffset = xTextOffset;
        this.yTextOffset = yTextOffset;
        return this;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, float mx, float my, float pticks) {
        if (this.buttonTextures != null) {
            WidgetTexture texture = this.buttonTextures.getButtonTexture(this.isHovered());
            FDRenderUtil.bindTexture(texture.resourceLocation);
            FDRenderUtil.blitWithBlend(graphics.m_280168_(), this.getX() - texture.xOffset, this.getY() - texture.yOffset, this.getWidth() + texture.xOffset * 2.0f, this.getHeight() + texture.yOffset * 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        }
        if (this.text != null) {
            Font font = Minecraft.m_91087_().f_91062_;
            List texts = font.m_92923_((FormattedText)this.text, Math.round((float)this.textWidth / this.textScale));
            int n = texts.size();
            Objects.requireNonNull(font);
            float height = (float)(n * 9) * this.textScale;
            float yStart = this.getY() + this.getHeight() / 2.0f - height / 2.0f;
            int i = 0;
            for (FormattedCharSequence text : texts) {
                float xStart = (float)(-font.m_92724_(text)) * this.textScale / 2.0f + this.getX() + this.getWidth() / 2.0f;
                Objects.requireNonNull(font);
                FDRenderUtil.renderScaledText(graphics, text, this.xTextOffset + xStart, this.yTextOffset + yStart + (float)(i * 9) * this.textScale, this.textScale, this.textDrawShadow, 0xFFFFFF);
                ++i;
            }
        }
        if (this.isHovered() && this.hover != null) {
            this.hover.hoverOver(this, graphics, mx, my, pticks);
        }
    }

    @Override
    public boolean onMouseClick(float mx, float my, int key) {
        boolean result;
        boolean bl = result = this.click != null && this.click.click(this, mx, my, key);
        if (result && this.sound != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)this.sound, (float)1.0f, (float)1.0f));
        }
        return result;
    }

    @Override
    public boolean onMouseRelease(float mx, float my, int key) {
        return false;
    }

    @Override
    public boolean onMouseScroll(float mx, float my, float scrollY) {
        return false;
    }

    @Override
    public boolean onCharTyped(char character, int idk) {
        return false;
    }

    @Override
    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @Override
    public boolean onKeyRelease(int keyCode, int scanCode, int modifiers) {
        return false;
    }
}

