/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.simple_screen;

import com.finderfeed.fdlib.data_structures.ObjectHolder;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.util.FDWidgetMovement;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;

public abstract class FDWidget
implements GuiEventListener,
Renderable,
NarratableEntry {
    private float x;
    private float y;
    private float width;
    private float height;
    private boolean focused = false;
    private boolean active = true;
    private boolean hovered = false;
    private FDWidget parent;
    protected Screen widgetOwner;
    protected HashMap<String, FDWidget> children = new LinkedHashMap<String, FDWidget>();
    protected FDWidgetMovement widgetMovement;

    public FDWidget(Screen screen, float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.widgetOwner = screen;
        this.widgetMovement = new FDWidgetMovement(this);
    }

    public abstract void renderWidget(GuiGraphics var1, float var2, float var3, float var4);

    public void renderChildren(GuiGraphics graphics, float mx, float my, float pticks) {
        boolean isChildHovered = false;
        for (FDWidget child : this.children.values()) {
            if (child.m_142518_() && FDRenderUtil.isMouseInBounds(mx, my, child.getX(), child.getY(), child.getWidth(), child.getHeight())) {
                isChildHovered = true;
            }
            child.m_88315_(graphics, (int)mx, (int)my, pticks);
        }
        this.hovered = !isChildHovered ? FDRenderUtil.isMouseInBounds(mx, my, this.getX(), this.getY(), this.getWidth(), this.getHeight()) : false;
    }

    public void m_88315_(GuiGraphics graphics, int mx, int my, float pticks) {
        this.widgetMovement.setWidgetPositionInRender();
        if (!this.m_142518_()) {
            return;
        }
        this.renderWidget(graphics, mx, my, pticks);
        this.useScissor();
        this.renderChildren(graphics, mx, my, pticks);
        this.endScissor();
    }

    public void useScissor() {
    }

    public void endScissor() {
    }

    public void tickChildren() {
        for (FDWidget child : this.children.values()) {
            child.tick();
        }
    }

    public void tick() {
        this.widgetMovement.tick();
        this.tickChildren();
    }

    public boolean isMoving() {
        return this.widgetMovement.isMoving();
    }

    public void moveWidgetTo(int time, float x, float y, Function<Float, Float> easing) {
        this.widgetMovement.moveTo(time, x, y, easing);
    }

    public void addChild(String id, FDWidget widget) {
        float widgetX = widget.getX();
        float widgetY = widget.getY();
        widget.setX(this.getX() + widgetX);
        widget.setY(this.getY() + widgetY);
        widget.parent = this;
        this.children.put(id, widget);
    }

    public FDWidget getChild(String id) {
        return this.children.get(id);
    }

    public abstract boolean onMouseClick(float var1, float var2, int var3);

    public abstract boolean onMouseRelease(float var1, float var2, int var3);

    public abstract boolean onMouseScroll(float var1, float var2, float var3);

    public abstract boolean onCharTyped(char var1, int var2);

    public abstract boolean onKeyPress(int var1, int var2, int var3);

    public abstract boolean onKeyRelease(int var1, int var2, int var3);

    public final boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.m_142518_()) {
            return false;
        }
        if (this.m_93696_()) {
            return this.onKeyPress(keyCode, scanCode, modifiers);
        }
        boolean result = false;
        for (FDWidget widget : this.children.values()) {
            result = widget.m_7933_(keyCode, scanCode, modifiers) || result;
        }
        return result;
    }

    public final boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (!this.m_142518_()) {
            return false;
        }
        if (this.m_93696_()) {
            return this.onKeyRelease(keyCode, scanCode, modifiers);
        }
        boolean result = false;
        for (FDWidget widget : this.children.values()) {
            result = widget.m_7920_(keyCode, scanCode, modifiers) || result;
        }
        return result;
    }

    public final boolean m_5534_(char character, int idk) {
        if (!this.m_142518_()) {
            return false;
        }
        boolean result = this.m_93696_();
        if (this.m_93696_()) {
            result = this.onCharTyped(character, idk);
        } else {
            for (FDWidget child : this.children.values()) {
                child.m_5534_(character, idk);
            }
        }
        return result;
    }

    private void setFocusStateFor(FDWidget widget) {
        this.m_93692_(false);
        for (FDWidget w : this.children.values()) {
            w.setFocusStateFor(widget);
        }
        if (widget == this) {
            this.m_93692_(true);
        }
    }

    private boolean mouseClick(double mx, double my, int key, ObjectHolder<FDWidget> result) {
        if (!this.m_142518_()) {
            return false;
        }
        boolean childWasClicked = false;
        if (FDRenderUtil.isMouseInBounds((float)mx, (float)my, this.x, this.y, this.width, this.height)) {
            for (FDWidget widget : this.children.values()) {
                if (!widget.mouseClick(mx, my, key, result)) continue;
                childWasClicked = true;
                break;
            }
            if (!childWasClicked) {
                boolean res = this.onMouseClick((float)mx, (float)my, key);
                if (res) {
                    result.setValue(this);
                }
                return res;
            }
        }
        return childWasClicked;
    }

    public final boolean m_6375_(double mx, double my, int key) {
        if (!this.m_142518_()) {
            return false;
        }
        ObjectHolder<Object> result = new ObjectHolder<Object>(null);
        this.mouseClick(mx, my, key, result);
        FDWidget clickedWidget = result.getValue();
        if (clickedWidget != null) {
            this.setFocusStateFor(clickedWidget);
            this.widgetOwner.m_7522_((GuiEventListener)clickedWidget);
        }
        return false;
    }

    private boolean mouseRelease(double mx, double my, int key, ObjectHolder<FDWidget> result) {
        if (!this.m_142518_()) {
            return false;
        }
        boolean childWasClicked = false;
        if (FDRenderUtil.isMouseInBounds((float)mx, (float)my, this.x, this.y, this.width, this.height)) {
            for (FDWidget widget : this.children.values()) {
                if (!widget.mouseRelease(mx, my, key, result)) continue;
                childWasClicked = true;
                break;
            }
            if (!childWasClicked) {
                boolean res = this.onMouseRelease((float)mx, (float)my, key);
                if (res) {
                    result.setValue(this);
                }
                return res;
            }
        }
        return childWasClicked;
    }

    public final boolean m_6348_(double mx, double my, int key) {
        if (!this.m_142518_()) {
            return false;
        }
        ObjectHolder<Object> result = new ObjectHolder<Object>(null);
        this.mouseRelease(mx, my, key, result);
        FDWidget clickedWidget = result.getValue();
        if (clickedWidget != null) {
            this.setFocusStateFor(clickedWidget);
        }
        return clickedWidget != null;
    }

    private boolean scroll(double mx, double my, double scrollY, ObjectHolder<FDWidget> interactedWidget) {
        if (!this.m_142518_()) {
            return false;
        }
        boolean childWasScrolled = false;
        if (FDRenderUtil.isMouseInBounds((float)mx, (float)my, this.x, this.y, this.width, this.height)) {
            for (FDWidget widget : this.children.values()) {
                if (!widget.scroll(mx, my, scrollY, interactedWidget)) continue;
                childWasScrolled = true;
                break;
            }
            if (!childWasScrolled) {
                boolean result = this.onMouseScroll((float)mx, (float)my, (float)scrollY);
                if (result) {
                    interactedWidget.setValue(this);
                }
                return result;
            }
        }
        return childWasScrolled;
    }

    public final boolean m_6050_(double mx, double my, double scrollY) {
        if (!this.m_142518_()) {
            return false;
        }
        ObjectHolder<Object> result = new ObjectHolder<Object>(null);
        this.scroll(mx, my, scrollY, result);
        FDWidget scrolledWidget = result.getValue();
        if (scrolledWidget != null) {
            this.setFocusStateFor(scrolledWidget);
        }
        return scrolledWidget != null;
    }

    public final boolean m_5953_(double mx, double my) {
        if (!this.m_142518_()) {
            return false;
        }
        boolean childUnderMouse = false;
        if (FDRenderUtil.isMouseInBounds((float)mx, (float)my, this.x, this.y, this.width, this.height)) {
            for (FDWidget widget : this.children.values()) {
                if (!widget.m_5953_(mx, my)) continue;
                childUnderMouse = true;
                break;
            }
            if (!childUnderMouse) {
                return true;
            }
        }
        return childUnderMouse;
    }

    public void setX(float x) {
        float d = x - this.x;
        for (FDWidget child : this.children.values()) {
            child.setX(child.getX() + d);
        }
        this.x = x;
    }

    public void setY(float y) {
        float d = y - this.y;
        for (FDWidget child : this.children.values()) {
            child.setY(child.getY() + d);
        }
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public boolean m_142518_() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public void unfocusChildren() {
        for (FDWidget child : this.children.values()) {
            child.m_93692_(false);
        }
    }

    public void moveChildren(float x, float y) {
        for (FDWidget widget : this.children.values()) {
            widget.setX(widget.getX() + x);
            widget.setY(widget.getY() + y);
        }
    }

    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    public boolean m_93696_() {
        return this.focused;
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public HashMap<String, FDWidget> getChildren() {
        return this.children;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public FDWidget getParent() {
        return this.parent;
    }
}

