/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen.screen_particles;

import com.finderfeed.fdlib.systems.screen.screen_particles.FDScreenParticle;
import com.finderfeed.fdlib.util.math.ComplexEasingFunction;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class FDTexturedSParticle
extends FDScreenParticle<FDTexturedSParticle> {
    private float u0 = 0.0f;
    private float v0 = 0.0f;
    private float u1 = 1.0f;
    private float v1 = 1.0f;
    private float maxQuadSize = 10.0f;
    private float currentQuadSize;
    private float quadSizeO;
    private ComplexEasingFunction scalingFunction = ComplexEasingFunction.builder().build();
    private ParticleRenderType renderType;

    public FDTexturedSParticle(Function<ResourceLocation, ? extends ParticleRenderType> factory, ResourceLocation location) {
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        TextureAtlas atlas = engine.f_107296_;
        TextureAtlasSprite atlasSprite = atlas.m_118316_(location);
        if (atlasSprite != null) {
            float width = engine.f_107296_.f_276067_;
            float height = engine.f_107296_.f_276070_;
            this.u0 = atlasSprite.m_118409_() + 1.0f / width;
            this.v0 = atlasSprite.m_118411_() + 1.0f / height;
            this.u1 = atlasSprite.m_118410_() - 1.0f / width;
            this.v1 = atlasSprite.m_118412_() - 1.0f / height;
            this.renderType = factory.apply(atlas.m_118330_());
        } else {
            this.renderType = factory.apply(location);
        }
    }

    public static FDTexturedSParticle create(Function<ResourceLocation, ? extends ParticleRenderType> factory, ResourceLocation location) {
        return new FDTexturedSParticle(factory, location);
    }

    @Override
    public void render(GuiGraphics graphics, BufferBuilder vertex, float partialTicks) {
        PoseStack matrices = graphics.m_280168_();
        float x = (float)this.getX(partialTicks);
        float y = (float)this.getY(partialTicks);
        float roll = this.getRoll(partialTicks);
        float halfQuadSize = this.getCurrentQuadSize(partialTicks) / 2.0f;
        matrices.m_85836_();
        matrices.m_252880_(x, y, 0.0f);
        matrices.m_252781_(Axis.f_252393_.m_252977_(roll));
        Matrix4f m = matrices.m_85850_().m_252922_();
        vertex.m_252986_(m, -halfQuadSize, -halfQuadSize, 0.0f).m_7421_(this.getU0(), this.getV0()).m_85950_(this.getR(), this.getG(), this.getB(), this.getA()).m_5752_();
        vertex.m_252986_(m, -halfQuadSize, halfQuadSize, 0.0f).m_7421_(this.getU0(), this.getV1()).m_85950_(this.getR(), this.getG(), this.getB(), this.getA()).m_5752_();
        vertex.m_252986_(m, halfQuadSize, halfQuadSize, 0.0f).m_7421_(this.getU1(), this.getV1()).m_85950_(this.getR(), this.getG(), this.getB(), this.getA()).m_5752_();
        vertex.m_252986_(m, halfQuadSize, -halfQuadSize, 0.0f).m_7421_(this.getU1(), this.getV0()).m_85950_(this.getR(), this.getG(), this.getB(), this.getA()).m_5752_();
        matrices.m_85849_();
    }

    @Override
    public void tick() {
        super.tick();
        this.quadSizeO = this.currentQuadSize;
        this.currentQuadSize = this.scalingFunction.apply((float)this.getAge() / (float)this.getLifetime()) * this.maxQuadSize;
    }

    @Override
    public ParticleRenderType getParticleRenderType() {
        return this.renderType;
    }

    public FDTexturedSParticle setQuadScaleOptions(ComplexEasingFunction function) {
        if ((double)function.getLength() > 1.01) {
            throw new RuntimeException("Area of easing function in textured particle should not be bigger than 1. ");
        }
        this.scalingFunction = function;
        return this;
    }

    public FDTexturedSParticle setDefaultScaleOut() {
        return this.setQuadScaleOptions(ComplexEasingFunction.builder().addArea(1.0f, FDEasings::reversedLinear).build());
    }

    public FDTexturedSParticle setDefaultScaleInOut() {
        return this.setQuadScaleOptions(ComplexEasingFunction.builder().addArea(0.5f, FDEasings::easeOut).addArea(0.5f, FDEasings::reversedEaseOut).build());
    }

    public FDTexturedSParticle setDefaultScaleIn() {
        return this.setQuadScaleOptions(ComplexEasingFunction.builder().addArea(1.0f, FDEasings::linear).build());
    }

    public FDTexturedSParticle setMaxQuadSize(float size) {
        this.maxQuadSize = size;
        return this;
    }

    public float getCurrentQuadSize(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.quadSizeO, (float)this.currentQuadSize);
    }

    @Override
    public void onAddedToEngine() {
        this.quadSizeO = this.currentQuadSize = this.scalingFunction.apply(0.0f) * this.maxQuadSize;
    }

    public float getCurrentQuadSize() {
        return this.currentQuadSize;
    }

    public float getQuadSizeO() {
        return this.quadSizeO;
    }

    public float getU0() {
        return this.u0;
    }

    public float getV0() {
        return this.v0;
    }

    public float getU1() {
        return this.u1;
    }

    public float getV1() {
        return this.v1;
    }
}

