/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen.screen_particles;

import com.finderfeed.fdlib.systems.screen.screen_particles.FDScreenParticle;
import com.finderfeed.fdlib.systems.screen.screen_particles.ScreenParticlesRenderEvent;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fdlib", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class FDScreenParticleEngine {
    private static HashMap<ParticleRenderType, List<FDScreenParticle>> SCREEN_PARTICLES = new HashMap();
    private static HashMap<ParticleRenderType, List<FDScreenParticle>> OVERLAY_PARTICLES = new HashMap();

    @SubscribeEvent
    public static void renderScreenEvent(ScreenEvent.Render.Post event) {
        if (MinecraftForge.EVENT_BUS.post((Event)new ScreenParticlesRenderEvent.Screen())) {
            return;
        }
        FDScreenParticleEngine.render(SCREEN_PARTICLES, event.getGuiGraphics(), FDRenderUtil.tryGetPartialTickIgnorePause());
    }

    @SubscribeEvent
    public static void onGuiRender(RenderGuiEvent.Post event) {
        if (MinecraftForge.EVENT_BUS.post((Event)new ScreenParticlesRenderEvent.Gui())) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        FDScreenParticleEngine.render(OVERLAY_PARTICLES, graphics, event.getPartialTick());
        graphics.m_280168_().m_85849_();
    }

    @SubscribeEvent
    public static void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        FDScreenParticleEngine.tickParticles(OVERLAY_PARTICLES);
        FDScreenParticleEngine.tickParticles(SCREEN_PARTICLES);
    }

    @SubscribeEvent
    public static void onScreenClose(ScreenEvent.Closing event) {
        FDScreenParticleEngine.clearParticles();
    }

    @SubscribeEvent
    public static void onLogoff(ClientPlayerNetworkEvent.LoggingOut event) {
        FDScreenParticleEngine.clearParticles();
    }

    private static void render(HashMap<ParticleRenderType, List<FDScreenParticle>> particles, GuiGraphics graphics, float partialTicks) {
        Tesselator tesselator = Tesselator.m_85913_();
        TextureManager manager = Minecraft.m_91087_().m_91097_();
        for (Map.Entry<ParticleRenderType, List<FDScreenParticle>> entry : particles.entrySet()) {
            List<FDScreenParticle> list = entry.getValue();
            if (list.isEmpty()) continue;
            ParticleRenderType renderType = entry.getKey();
            BufferBuilder builder = Tesselator.m_85913_().m_85915_();
            renderType.m_6505_(builder, manager);
            for (FDScreenParticle particle : list) {
                particle.render(graphics, builder, partialTicks);
            }
            renderType.m_6294_(tesselator);
        }
    }

    public static void tickParticles(HashMap<ParticleRenderType, List<FDScreenParticle>> particles) {
        for (Map.Entry<ParticleRenderType, List<FDScreenParticle>> entry : particles.entrySet()) {
            Iterator<FDScreenParticle> iter = entry.getValue().iterator();
            while (iter.hasNext()) {
                FDScreenParticle particle = iter.next();
                if (particle.isRemoved()) {
                    iter.remove();
                    continue;
                }
                particle.tick();
            }
        }
    }

    public static void clearParticles() {
        SCREEN_PARTICLES.clear();
    }

    public static void addScreenParticle(FDScreenParticle particle) {
        ParticleRenderType renderType = particle.getParticleRenderType();
        SCREEN_PARTICLES.computeIfAbsent(renderType, type -> {
            LinkedList particles = new LinkedList();
            return particles;
        }).add(particle);
        particle.onAddedToEngine();
    }

    public static void addOverlayParticle(FDScreenParticle particle) {
        ParticleRenderType renderType = particle.getParticleRenderType();
        OVERLAY_PARTICLES.computeIfAbsent(renderType, type -> {
            LinkedList particles = new LinkedList();
            return particles;
        }).add(particle);
        particle.onAddedToEngine();
    }
}

