/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.config.packets;

import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.config.JsonConfig;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

@RegisterFDPacket(value="fdlib:update_all_configs")
public class JsonConfigSyncPacket
extends FDPacket {
    private List<String> names;
    private List<String> configs;

    public JsonConfigSyncPacket() {
        this.names = new ArrayList<String>();
        this.configs = new ArrayList<String>();
        for (JsonConfig entry : FDRegistries.CONFIGS.get()) {
            if (entry.isClientside()) continue;
            this.names.add(FDRegistries.CONFIGS.get().getKey((Object)entry).toString());
            this.configs.add(entry.getLoadedJson());
        }
    }

    public JsonConfigSyncPacket(FriendlyByteBuf buf) {
        int i;
        int namesLen = buf.readInt();
        this.names = new ArrayList<String>();
        for (i = 0; i < namesLen; ++i) {
            this.names.add(buf.m_130277_());
        }
        this.configs = new ArrayList<String>();
        for (i = 0; i < namesLen; ++i) {
            this.configs.add(buf.m_130277_());
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.names.size());
        for (String name : this.names) {
            buf.m_130070_(name);
        }
        for (String sconfig : this.configs) {
            buf.m_130070_(sconfig);
        }
    }

    @Override
    public void clientAction(Supplier<NetworkEvent.Context> context) {
        for (int i = 0; i < this.names.size(); ++i) {
            JsonConfig config = (JsonConfig)FDRegistries.CONFIGS.get().getValue(ResourceLocation.m_135820_((String)this.names.get(i)));
            if (config.isClientside()) continue;
            JsonObject object = JsonParser.parseString((String)this.configs.get(i)).getAsJsonObject();
            config.setLoadedJson(object);
            config.parseJson(object);
        }
    }

    @Override
    public void serverAction(Supplier<NetworkEvent.Context> context) {
    }
}

