/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.models;

import com.finderfeed.fdlib.systems.bedrock.models.FDFace;
import com.finderfeed.fdlib.systems.bedrock.models.FDVertex;
import com.finderfeed.fdlib.systems.bedrock.models.JsonHelper;
import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class FDCube {
    public static final NetworkCodec<FDCube> CODEC = NetworkCodec.composite(FDFace.CODEC, cube -> cube.faces[0], FDFace.CODEC, cube -> cube.faces[1], FDFace.CODEC, cube -> cube.faces[2], FDFace.CODEC, cube -> cube.faces[3], FDFace.CODEC, cube -> cube.faces[4], FDFace.CODEC, cube -> cube.faces[5], FDCube::new);
    private static final float POS_MULTIPLIER = 0.0625f;
    private FDFace[] faces = new FDFace[6];
    private static final Vec3[] normals = new Vec3[]{new Vec3(0.0, 0.0, -1.0), new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, -1.0, 0.0)};

    private FDCube(FDFace ... faces) {
        this.faces[0] = faces[0];
        this.faces[1] = faces[1];
        this.faces[2] = faces[2];
        this.faces[3] = faces[3];
        this.faces[4] = faces[4];
        this.faces[5] = faces[5];
    }

    private FDCube(FDFace f1, FDFace f2, FDFace f3, FDFace f4, FDFace f5, FDFace f6) {
        this.faces[0] = f1;
        this.faces[1] = f2;
        this.faces[2] = f3;
        this.faces[3] = f4;
        this.faces[4] = f5;
        this.faces[5] = f6;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack matrices, VertexConsumer vertex, int light, int overlay, float r, float g, float b, float a) {
        matrices.m_85836_();
        Matrix4f m = matrices.m_85850_().m_252922_();
        Matrix3f n = matrices.m_85850_().m_252943_();
        for (FDFace fdFace : this.faces) {
            Vector3f normal = n.transform(new Vector3f(fdFace.getNormal().x, fdFace.getNormal().y, fdFace.getNormal().z));
            for (FDVertex v : fdFace.getVertices()) {
                Vector3f vertexPos = v.getPosition();
                vertex.m_252986_(m, vertexPos.x * 0.0625f, vertexPos.y * 0.0625f, vertexPos.z * 0.0625f);
                vertex.m_85950_(r, g, b, a);
                vertex.m_7421_(v.getU(), v.getV());
                vertex.m_86008_(overlay);
                vertex.m_85969_(light);
                vertex.m_5601_(normal.x, normal.y, normal.z);
                vertex.m_5752_();
            }
        }
        matrices.m_85849_();
    }

    public FDFace[] getFaces() {
        return this.faces;
    }

    public static FDCube fromJson(JsonObject scube, Vector3f bonePivot, int textureWidth, int textureHeight, float scale) {
        boolean shouldRotate;
        if (scube.has("mirror")) {
            throw new RuntimeException("Mirror UV is not supported!" + scube);
        }
        Vector3f origin = JsonHelper.parseVector3f((JsonElement)scube.getAsJsonArray("origin"));
        Vector3f size = JsonHelper.parseVector3f((JsonElement)scube.getAsJsonArray("size"));
        float inflate = JsonHelper.parseFloat(scube, "inflate");
        size = size.add(inflate * 2.0f, inflate * 2.0f, inflate * 2.0f);
        origin = new Vector3f(-origin.x - size.x - inflate, origin.y - inflate, origin.z - inflate);
        Vec3 pivot = JsonHelper.parseVec3(scube, "pivot").m_82542_(-1.0, 1.0, 1.0);
        Vec3 rotation = JsonHelper.parseVec3(scube, "rotation").m_82542_(-1.0, -1.0, 1.0);
        Matrix4fStack matrices = new Matrix4fStack(4);
        matrices.pushMatrix();
        matrices.translate((float)pivot.f_82479_, (float)pivot.f_82480_, (float)pivot.f_82481_);
        boolean bl = shouldRotate = rotation.f_82479_ != 0.0 || rotation.f_82480_ != 0.0 || rotation.f_82481_ != 0.0;
        if (shouldRotate) {
            Quaternionf q = new Quaternionf().rotationZYX((float)Math.toRadians(rotation.f_82481_), (float)Math.toRadians(rotation.f_82480_), (float)Math.toRadians(rotation.f_82479_));
            Matrix4f mat = new Matrix4f();
            q.get(mat);
            matrices.mul((Matrix4fc)mat);
        }
        matrices.translate((float)(-pivot.f_82479_), (float)(-pivot.f_82480_), (float)(-pivot.f_82481_));
        Matrix4fStack m = matrices;
        Vector3f cubeCenter = origin.add((Vector3fc)size.mul(0.5f, 0.5f, 0.5f, new Vector3f()), new Vector3f());
        Vector3f between = origin.sub((Vector3fc)cubeCenter, new Vector3f()).mul(scale - 1.0f, scale - 1.0f, scale - 1.0f);
        origin = origin.add((Vector3fc)between);
        size = size.mul(scale, scale, scale, new Vector3f());
        Vector3f v1 = FDCube.mul(new Vector3f((Vector3fc)origin), (Matrix4f)m);
        Vector3f v2 = FDCube.mul(origin.add(size.x, 0.0f, 0.0f, new Vector3f()), (Matrix4f)m);
        Vector3f v3 = FDCube.mul(origin.add(0.0f, size.y, 0.0f, new Vector3f()), (Matrix4f)m);
        Vector3f v4 = FDCube.mul(origin.add(0.0f, 0.0f, size.z, new Vector3f()), (Matrix4f)m);
        Vector3f v5 = FDCube.mul(origin.add(size.x, size.y, 0.0f, new Vector3f()), (Matrix4f)m);
        Vector3f v6 = FDCube.mul(origin.add(0.0f, size.y, size.z, new Vector3f()), (Matrix4f)m);
        Vector3f v7 = FDCube.mul(origin.add(size.x, 0.0f, size.z, new Vector3f()), (Matrix4f)m);
        Vector3f v8 = FDCube.mul(origin.add((Vector3fc)size, new Vector3f()), (Matrix4f)m);
        Matrix3f mn = matrices.normal(new Matrix3f());
        List<Vector3f> tnormals = Arrays.stream(normals).map(normal -> mn.transform((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_, new Vector3f())).map(vector3f -> new Vector3f(vector3f.x, vector3f.y, vector3f.z)).toList();
        matrices.popMatrix();
        JsonElement faceDatas = scube.get("uv");
        FDFace north = null;
        FDFace east = null;
        FDFace south = null;
        FDFace west = null;
        FDFace up = null;
        FDFace down = null;
        if (!faceDatas.isJsonArray()) {
            north = FDCube.createFace(v1, v2, v5, v3, tnormals.get(0), faceDatas.getAsJsonObject().getAsJsonObject("north"), textureWidth, textureHeight);
            east = FDCube.createFace(v2, v7, v8, v5, tnormals.get(1), faceDatas.getAsJsonObject().getAsJsonObject("east"), textureWidth, textureHeight);
            south = FDCube.createFace(v7, v4, v6, v8, tnormals.get(2), faceDatas.getAsJsonObject().getAsJsonObject("south"), textureWidth, textureHeight);
            west = FDCube.createFace(v4, v1, v3, v6, tnormals.get(3), faceDatas.getAsJsonObject().getAsJsonObject("west"), textureWidth, textureHeight);
            up = FDCube.createFace(v3, v5, v8, v6, tnormals.get(4), faceDatas.getAsJsonObject().getAsJsonObject("up"), textureWidth, textureHeight);
            down = FDCube.createFace(v4, v7, v2, v1, tnormals.get(5), faceDatas.getAsJsonObject().getAsJsonObject("down"), textureWidth, textureHeight);
        } else {
            Vec2 uv = JsonHelper.parseVec2(faceDatas);
            float x = (float)Math.floor(size.x / scale - inflate * 2.0f);
            float y = (float)Math.floor(size.y / scale - inflate * 2.0f);
            float z = (float)Math.floor(size.z / scale - inflate * 2.0f);
            north = FDCube.createFace(v1, v2, v5, v3, tnormals.get(0), new Vec2(uv.f_82470_ + z + x, uv.f_82471_ + z + y), new Vec2(uv.f_82470_ + z, uv.f_82471_ + z + y), new Vec2(uv.f_82470_ + z, uv.f_82471_ + z), new Vec2(uv.f_82470_ + z + x, uv.f_82471_ + z), textureWidth, textureHeight);
            east = FDCube.createFace(v2, v7, v8, v5, tnormals.get(1), new Vec2(uv.f_82470_ + z, uv.f_82471_ + z + y), new Vec2(uv.f_82470_, uv.f_82471_ + z + y), new Vec2(uv.f_82470_, uv.f_82471_ + z), new Vec2(uv.f_82470_ + z, uv.f_82471_ + z), textureWidth, textureHeight);
            south = FDCube.createFace(v7, v4, v6, v8, tnormals.get(2), new Vec2(uv.f_82470_ + z + x + z + x, uv.f_82471_ + z + y), new Vec2(uv.f_82470_ + z + x + z, uv.f_82471_ + z + y), new Vec2(uv.f_82470_ + z + x + z, uv.f_82471_ + z), new Vec2(uv.f_82470_ + z + x + z + x, uv.f_82471_ + z), textureWidth, textureHeight);
            west = FDCube.createFace(v4, v1, v3, v6, tnormals.get(3), new Vec2(uv.f_82470_ + z + x + z, uv.f_82471_ + z + y), new Vec2(uv.f_82470_ + z + x, uv.f_82471_ + z + y), new Vec2(uv.f_82470_ + z + x, uv.f_82471_ + z), new Vec2(uv.f_82470_ + z + x + z, uv.f_82471_ + z), textureWidth, textureHeight);
            up = FDCube.createFace(v3, v5, v8, v6, tnormals.get(4), new Vec2(uv.f_82470_ + z + x, uv.f_82471_ + z), new Vec2(uv.f_82470_ + z, uv.f_82471_ + z), new Vec2(uv.f_82470_ + z, uv.f_82471_), new Vec2(uv.f_82470_ + z + x, uv.f_82471_), textureWidth, textureHeight);
            down = FDCube.createFace(v4, v7, v2, v1, tnormals.get(5), new Vec2(uv.f_82470_ + z + x + x, uv.f_82471_), new Vec2(uv.f_82470_ + z + x, uv.f_82471_), new Vec2(uv.f_82470_ + z + x, uv.f_82471_ + z), new Vec2(uv.f_82470_ + z + x + x, uv.f_82471_ + z), textureWidth, textureHeight);
        }
        FDCube cube = new FDCube(north, east, south, west, up, down);
        for (FDFace fdFace : cube.faces) {
            for (FDVertex vertex : fdFace.getVertices()) {
                vertex.getPosition().sub((Vector3fc)bonePivot);
            }
        }
        return cube;
    }

    private static FDFace createFace(Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Vector3f normal, Vec2 uv1, Vec2 uv2, Vec2 uv3, Vec2 uv4, int texWidth, int texHeight) {
        Vec2 nuv1 = new Vec2(uv1.f_82470_ / (float)texWidth, uv1.f_82471_ / (float)texHeight);
        Vec2 nuv2 = new Vec2(uv2.f_82470_ / (float)texWidth, uv2.f_82471_ / (float)texHeight);
        Vec2 nuv3 = new Vec2(uv3.f_82470_ / (float)texWidth, uv3.f_82471_ / (float)texHeight);
        Vec2 nuv4 = new Vec2(uv4.f_82470_ / (float)texWidth, uv4.f_82471_ / (float)texHeight);
        FDVertex vertex1 = new FDVertex(nuv1.f_82470_, nuv1.f_82471_, v1);
        FDVertex vertex2 = new FDVertex(nuv2.f_82470_, nuv2.f_82471_, v2);
        FDVertex vertex3 = new FDVertex(nuv3.f_82470_, nuv3.f_82471_, v3);
        FDVertex vertex4 = new FDVertex(nuv4.f_82470_, nuv4.f_82471_, v4);
        return new FDFace(normal, vertex4, vertex3, vertex2, vertex1);
    }

    private static FDFace createFace(Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Vector3f normal, JsonObject faceData, int texWidth, int texHeight) {
        Vec2 uv = JsonHelper.parseVec2((JsonElement)faceData.getAsJsonArray("uv"));
        Vec2 uv_size = JsonHelper.parseVec2((JsonElement)faceData.getAsJsonArray("uv_size"));
        uv = new Vec2(uv.f_82470_ / (float)texWidth, uv.f_82471_ / (float)texHeight);
        uv_size = new Vec2(uv_size.f_82470_ / (float)texWidth, uv_size.f_82471_ / (float)texHeight);
        FDVertex vertex1 = new FDVertex(uv.f_82470_ + uv_size.f_82470_, uv.f_82471_ + uv_size.f_82471_, v1);
        FDVertex vertex2 = new FDVertex(uv.f_82470_, uv.f_82471_ + uv_size.f_82471_, v2);
        FDVertex vertex3 = new FDVertex(uv.f_82470_, uv.f_82471_, v3);
        FDVertex vertex4 = new FDVertex(uv.f_82470_ + uv_size.f_82470_, uv.f_82471_, v4);
        return new FDFace(normal, vertex4, vertex3, vertex2, vertex1);
    }

    private static Vector3f mul(Vector3f v, Matrix4f matrix4f) {
        Vector4f vc = FDCube.fromVec3ToVec4(v).mul((Matrix4fc)matrix4f);
        return new Vector3f(vc.x, vc.y, vc.z);
    }

    private static Vector4f fromVec3ToVec4(Vector3f v) {
        return new Vector4f(v.x, v.y, v.z, 1.0f);
    }
}

