/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;
import org.objectweb.asm.Type;

public class FDHelpers {
    public static final Gson GSON = new GsonBuilder().create();

    public static List<Entity> traceEntities(Level level, Vec3 start, Vec3 end, double boxInflate, Predicate<Entity> predicate) {
        List list = level.m_6443_(Entity.class, new AABB(start, end).m_82400_(boxInflate), predicate);
        Iterator entityIterator = list.iterator();
        while (entityIterator.hasNext()) {
            Optional opt2;
            Entity e = (Entity)entityIterator.next();
            AABB box = e.m_20191_().m_82400_(boxInflate);
            Optional opt = box.m_82371_(start, end);
            if (!opt.isEmpty() || !(opt2 = box.m_82371_(end, start)).isEmpty()) continue;
            entityIterator.remove();
        }
        return list;
    }

    public static JsonElement readJsonFileFromAssets(ResourceLocation location, String format) {
        ResourceLocation rl = ResourceLocation.m_214293_((String)location.m_135827_(), (String)(location.m_135815_() + format));
        try {
            byte[] bytes = FDHelpers.readFileFromAssets(rl);
            String s = new String(bytes);
            JsonElement element = (JsonElement)GSON.fromJson(s, JsonElement.class);
            return element;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static JsonElement readJsonFileFromAssets(ResourceLocation location) {
        return FDHelpers.readJsonFileFromAssets(location, ".json");
    }

    public static byte[] readFileFromAssets(ResourceLocation rl) throws IOException {
        ModList list = ModList.get();
        String modid = rl.m_135827_();
        String location = rl.m_135815_();
        IModFileInfo info = list.getModFileById(modid);
        if (info == null) {
            throw new IOException("Cannot locate mod " + modid);
        }
        IModFile file = info.getFile();
        Path path = file.findResource(new String[]{"assets", modid, location});
        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("File not found: " + rl);
        }
        return Files.readAllBytes(path);
    }

    public static List<Field> getAnnotatedFieldsInClass(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> annotated = new ArrayList<Field>();
        for (Field field : fields) {
            if (field.getAnnotation(annotationClass) == null) continue;
            annotated.add(field);
        }
        return annotated;
    }

    public static List<Field> getAllAnnotatedFieldsInClass(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        ArrayList<Field> fields = new ArrayList<Field>(FDHelpers.getAnnotatedFieldsInClass(clazz, annotationClass));
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            fields.addAll(FDHelpers.getAnnotatedFieldsInClass(superclass, annotationClass));
        }
        return fields;
    }

    public static List<ClassFields> collectAllAnnotatedFieldsInClass(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        ArrayList<ClassFields> classFields = new ArrayList<ClassFields>();
        List<Field> fields = FDHelpers.getAnnotatedFieldsInClass(clazz, annotationClass);
        if (!fields.isEmpty()) {
            classFields.add(new ClassFields(clazz, fields));
        }
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            fields = FDHelpers.getAnnotatedFieldsInClass(superclass, annotationClass);
            if (fields.isEmpty()) continue;
            classFields.add(new ClassFields(superclass, fields));
        }
        return classFields;
    }

    public static <T> List<Class<?>> getAnnotatedClasses(Class<T> annotationClass) {
        Type type = Type.getType(annotationClass);
        ModList modList = ModList.get();
        List datas = modList.getAllScanData();
        ArrayList classes = new ArrayList();
        for (ModFileScanData data : datas) {
            Set annotationDatas = data.getAnnotations();
            for (ModFileScanData.AnnotationData adata : annotationDatas) {
                if (!adata.annotationType().equals((Object)type)) continue;
                try {
                    Class<?> clazz = Class.forName(adata.clazz().getClassName());
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unexpected error - class not found: " + adata.clazz().getClassName());
                }
            }
        }
        return classes;
    }

    public record ClassFields(Class<?> owner, List<Field> fields) {
    }
}

