/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib;

import com.finderfeed.fdlib.systems.shake.ScreenShake;
import com.finderfeed.fdlib.systems.shake.ScreenShakeInstance;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fdlib", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientMixinHandler {
    private static final List<ScreenShakeInstance> SHAKES = new ArrayList<ScreenShakeInstance>();
    private static boolean renderShake = true;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<ScreenShakeInstance> iter = SHAKES.iterator();
        while (iter.hasNext()) {
            ScreenShakeInstance inst = iter.next();
            if (!inst.hasEnded()) {
                inst.tick();
                continue;
            }
            iter.remove();
        }
    }

    @SubscribeEvent
    public static void onLogoff(ClientPlayerNetworkEvent.LoggingOut event) {
        SHAKES.clear();
    }

    public static void beforeLevel() {
        renderShake = true;
    }

    public static void beforeHand() {
        renderShake = false;
    }

    public static void bobHurt(PoseStack matrices, float pticks) {
        if (!renderShake) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        for (ScreenShakeInstance instance : SHAKES) {
            ScreenShake shake = instance.shake;
            int time = instance.currentTime;
            shake.process(matrices, time, pticks);
        }
    }

    public static void addShake(ScreenShake shake) {
        SHAKES.add(new ScreenShakeInstance(shake));
    }
}

