/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube.builder;

import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.filters.Resolver;
import com.almostreliable.lootjs.predicate.CustomItemPredicate;
import com.almostreliable.lootjs.predicate.ExtendedEntityFlagsPredicate;
import com.almostreliable.lootjs.predicate.MultiEntityTypePredicate;
import com.almostreliable.lootjs.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class EntityPredicateBuilderJS
implements ExtendedEntityFlagsPredicate.IBuilder<EntityPredicate> {
    private final EntityPredicate.Builder vanillaBuilder = EntityPredicate.Builder.m_36633_();
    private final Map<MobEffect, MobEffectsPredicate.MobEffectInstancePredicate> effects = new HashMap<MobEffect, MobEffectsPredicate.MobEffectInstancePredicate>();
    private final ExtendedEntityFlagsPredicate.Builder flagsBuilder = new ExtendedEntityFlagsPredicate.Builder();
    @Nullable
    private EntityEquipmentPredicate.Builder equipmentPredicateBuilder;
    @Nullable
    private FluidPredicate fluidPredicate;
    @Nullable
    private BlockPredicate blockPredicate;

    public EntityPredicateBuilderJS isOnFire(boolean flag) {
        this.flagsBuilder.isOnFire(flag);
        return this;
    }

    public EntityPredicateBuilderJS isCrouching(boolean flag) {
        this.flagsBuilder.isCrouching(flag);
        return this;
    }

    public EntityPredicateBuilderJS isSprinting(boolean flag) {
        this.flagsBuilder.isSprinting(flag);
        return this;
    }

    public EntityPredicateBuilderJS isSwimming(boolean flag) {
        this.flagsBuilder.isSwimming(flag);
        return this;
    }

    public EntityPredicateBuilderJS isBaby(boolean flag) {
        this.flagsBuilder.isBaby(flag);
        return this;
    }

    public EntityPredicateBuilderJS isInWater(boolean flag) {
        this.flagsBuilder.isInWater(flag);
        return this;
    }

    public EntityPredicateBuilderJS isUnderWater(boolean flag) {
        this.flagsBuilder.isUnderWater(flag);
        return this;
    }

    public EntityPredicateBuilderJS isMonster(boolean flag) {
        this.flagsBuilder.isMonster(flag);
        return this;
    }

    public EntityPredicateBuilderJS isCreature(boolean flag) {
        this.flagsBuilder.isCreature(flag);
        return this;
    }

    public EntityPredicateBuilderJS isOnGround(boolean flag) {
        this.flagsBuilder.isOnGround(flag);
        return this;
    }

    public EntityPredicateBuilderJS isUndeadMob(boolean flag) {
        this.flagsBuilder.isUndeadMob(flag);
        return this;
    }

    public EntityPredicateBuilderJS isArthropodMob(boolean flag) {
        this.flagsBuilder.isArthropodMob(flag);
        return this;
    }

    public EntityPredicateBuilderJS isIllegarMob(boolean flag) {
        this.flagsBuilder.isIllegarMob(flag);
        return this;
    }

    public EntityPredicateBuilderJS isWaterMob(boolean flag) {
        this.flagsBuilder.isWaterMob(flag);
        return this;
    }

    public EntityPredicateBuilderJS matchBlock(Resolver resolver, Map<String, String> propertyMap) {
        BlockPredicate.Builder builder = BlockPredicate.Builder.m_17924_();
        if (resolver instanceof Resolver.ByEntry) {
            Resolver.ByEntry byEntry = (Resolver.ByEntry)resolver;
            Block block = (Block)byEntry.resolve(BuiltInRegistries.f_256975_);
            StatePropertiesPredicate.Builder properties = Utils.createProperties(block, propertyMap);
            builder.m_17929_(properties.m_67706_());
            builder.m_146726_(new Block[]{block});
        } else if (resolver instanceof Resolver.ByTagKey) {
            Resolver.ByTagKey byTag = (Resolver.ByTagKey)resolver;
            TagKey tagKey = byTag.resolve(Registries.f_256747_);
            builder.m_204027_(tagKey);
        }
        this.blockPredicate = builder.m_17931_();
        return this;
    }

    public EntityPredicateBuilderJS matchBlock(Resolver resolver) {
        return this.matchBlock(resolver, new HashMap<String, String>());
    }

    public EntityPredicateBuilderJS matchFluid(Resolver resolver) {
        if (resolver instanceof Resolver.ByEntry) {
            Resolver.ByEntry byEntry = (Resolver.ByEntry)resolver;
            Fluid fluid = (Fluid)byEntry.resolve(BuiltInRegistries.f_257020_);
            this.fluidPredicate = new FluidPredicate(null, fluid, StatePropertiesPredicate.f_67658_);
        } else if (resolver instanceof Resolver.ByTagKey) {
            Resolver.ByTagKey byTag = (Resolver.ByTagKey)resolver;
            TagKey tagKey = byTag.resolve(Registries.f_256808_);
            this.fluidPredicate = new FluidPredicate(tagKey, null, StatePropertiesPredicate.f_67658_);
        }
        return this;
    }

    public EntityPredicateBuilderJS hasEffect(MobEffect effect, int amplifier) {
        MinMaxBounds.Ints bounds = MinMaxBounds.Ints.m_55386_((int)amplifier);
        MobEffectsPredicate.MobEffectInstancePredicate predicate = new MobEffectsPredicate.MobEffectInstancePredicate(bounds, MinMaxBounds.Ints.f_55364_, null, null);
        this.effects.put(effect, predicate);
        return this;
    }

    public EntityPredicateBuilderJS hasEffect(MobEffect effect) {
        return this.hasEffect(effect, 0);
    }

    public EntityPredicateBuilderJS nbt(CompoundTag nbt) {
        this.vanillaBuilder.m_36654_(new NbtPredicate(nbt));
        return this;
    }

    public EntityPredicateBuilderJS matchMount(Consumer<EntityPredicateBuilderJS> action) {
        EntityPredicateBuilderJS mountPredicateBuilder = new EntityPredicateBuilderJS();
        action.accept(mountPredicateBuilder);
        this.vanillaBuilder.m_36644_(mountPredicateBuilder.build());
        return this;
    }

    public EntityPredicateBuilderJS matchTargetedEntity(Consumer<EntityPredicateBuilderJS> action) {
        EntityPredicateBuilderJS vehiclePredicateBuilder = new EntityPredicateBuilderJS();
        action.accept(vehiclePredicateBuilder);
        this.vanillaBuilder.m_36663_(vehiclePredicateBuilder.build());
        return this;
    }

    public EntityPredicateBuilderJS matchSlot(EquipmentSlot slot, ItemFilter itemFilter) {
        if (this.equipmentPredicateBuilder == null) {
            this.equipmentPredicateBuilder = new EntityEquipmentPredicate.Builder();
        }
        CustomItemPredicate predicate = new CustomItemPredicate(itemFilter);
        switch (slot) {
            case MAINHAND: {
                this.equipmentPredicateBuilder.m_149928_((ItemPredicate)predicate);
                break;
            }
            case OFFHAND: {
                this.equipmentPredicateBuilder.m_149930_((ItemPredicate)predicate);
                break;
            }
            case FEET: {
                this.equipmentPredicateBuilder.m_32212_((ItemPredicate)predicate);
                break;
            }
            case LEGS: {
                this.equipmentPredicateBuilder.m_32210_((ItemPredicate)predicate);
                break;
            }
            case CHEST: {
                this.equipmentPredicateBuilder.m_32208_((ItemPredicate)predicate);
                break;
            }
            case HEAD: {
                this.equipmentPredicateBuilder.m_32205_((ItemPredicate)predicate);
            }
        }
        return this;
    }

    public EntityPredicateBuilderJS anyType(Resolver ... resolvers) {
        ArrayList types = new ArrayList();
        ArrayList tags = new ArrayList();
        for (Resolver resolver : resolvers) {
            if (resolver instanceof Resolver.ByEntry) {
                Resolver.ByEntry byEntry = (Resolver.ByEntry)resolver;
                types.add((EntityType)byEntry.resolve(BuiltInRegistries.f_256780_));
                continue;
            }
            if (!(resolver instanceof Resolver.ByTagKey)) continue;
            Resolver.ByTagKey byTag = (Resolver.ByTagKey)resolver;
            tags.add(byTag.resolve(Registries.f_256939_));
        }
        this.vanillaBuilder.m_36646_((EntityTypePredicate)new MultiEntityTypePredicate(tags, types));
        return this;
    }

    @Override
    public EntityPredicate build() {
        this.tryBuildFLags();
        this.tryBuildEffects();
        this.tryBuildEquipment();
        this.tryBuildLocation();
        return this.vanillaBuilder.m_36662_();
    }

    private void tryBuildLocation() {
        LocationPredicate.Builder locationBuilder = new LocationPredicate.Builder();
        if (this.blockPredicate != null) {
            locationBuilder.m_52652_(this.blockPredicate);
        }
        if (this.fluidPredicate != null) {
            locationBuilder.m_153966_(this.fluidPredicate);
        }
        this.vanillaBuilder.m_36650_(locationBuilder.m_52658_());
    }

    private void tryBuildEquipment() {
        if (this.equipmentPredicateBuilder != null) {
            this.vanillaBuilder.m_36640_(this.equipmentPredicateBuilder.m_32207_());
        }
    }

    private void tryBuildEffects() {
        if (!this.effects.isEmpty()) {
            this.vanillaBuilder.m_36652_(new MobEffectsPredicate(this.effects));
        }
    }

    private void tryBuildFLags() {
        this.vanillaBuilder.m_36642_((EntityFlagsPredicate)this.flagsBuilder.build());
    }
}

