/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.label;

import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUsePacket;
import ca.teamdman.sfm.common.util.SFMStreamUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public record LabelGunPlanTargets(Set<BlockPos> positions, Set<BlockPos> warnBecauseNoCableNeighbour) {
    public static LabelGunPlanTargets getTargets(Level level, ServerboundLabelGunUsePacket msg) {
        Block targetBlock = level.m_8055_(msg.pos()).m_60734_();
        if (!msg.isContiguousModifierActive()) {
            return new LabelGunPlanTargets(Set.of(msg.pos()), Set.of());
        }
        Set cablePositions = level.m_5776_() ? SFMStreamUtils.get3DNeighbours(msg.pos()).filter(pos -> CableNetwork.isCable(level, pos)).flatMap(cablePos -> CableNetwork.discoverCables(level, cablePos)).collect(Collectors.toSet()) : SFMStreamUtils.get3DNeighbours(msg.pos()).map(suspected_cable_pos -> CableNetworkManager.getOrRegisterNetworkFromCablePosition(level, suspected_cable_pos)).filter(Optional::isPresent).map(Optional::get).flatMap(CableNetwork::getCablePositions).collect(Collectors.toSet());
        HashSet<BlockPos> warnBecauseNoCableNeighbour = new HashSet<BlockPos>();
        Predicate<BlockPos> isAdjacentToCable = p -> {
            boolean isAdjacent = SFMStreamUtils.get3DNeighbours(p).anyMatch(cablePositions::contains);
            if (!isAdjacent) {
                warnBecauseNoCableNeighbour.add((BlockPos)p);
            }
            return isAdjacent;
        };
        Set<BlockPos> targets = SFMStreamUtils.getRecursiveStream((current, nextQueue, results) -> {
            results.accept(current);
            SFMStreamUtils.get3DNeighboursIncludingKittyCorner(current).filter(p -> level.m_8055_(p).m_60734_() == targetBlock).filter(isAdjacentToCable).forEach(nextQueue);
        }, msg.pos()).collect(Collectors.toSet());
        return new LabelGunPlanTargets(targets, warnBecauseNoCableNeighbour);
    }
}

