/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.entity.DripstoneSpikeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class SpikeRenderer
extends GeoEntityRenderer<DripstoneSpikeEntity> {
    public SpikeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new DripGeoModel());
    }

    public SpikeRenderer(EntityRendererProvider.Context renderManager, ResourceLocation textureLocation) {
        super(renderManager, (GeoModel)new DripGeoModel(textureLocation));
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, DripstoneSpikeEntity animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        widthScale = (float)animatable.getAoe();
        heightScale = (float)(animatable.getPierce() + animatable.getAoe() - 1.0);
        super.scaleModelForRender(widthScale, heightScale, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    private static class DripGeoModel
    extends GeoModel<DripstoneSpikeEntity> {
        ResourceLocation AltTexture;
        static final ResourceLocation MODEL = ArsElemental.prefix("geo/spike.geo.json");
        static final ResourceLocation TEXTURE = ArsElemental.prefix("textures/entity/spike.png");
        static final ResourceLocation ANIMATIONS = ArsElemental.prefix("animations/spike.animation.json");

        public DripGeoModel() {
        }

        public DripGeoModel(ResourceLocation textureLocation) {
            this.AltTexture = textureLocation;
        }

        public ResourceLocation getModelResource(DripstoneSpikeEntity dripstoneSpikeEntity) {
            return MODEL;
        }

        public ResourceLocation getTextureResource(DripstoneSpikeEntity dripstoneSpikeEntity) {
            return this.AltTexture != null ? this.AltTexture : TEXTURE;
        }

        public ResourceLocation getAnimationResource(DripstoneSpikeEntity dripstoneSpikeEntity) {
            return ANIMATIONS;
        }
    }
}

