/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.init.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class BulletHoleOption
implements ParticleOptions {
    public static final Codec<BulletHoleOption> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("dir").forGetter(option -> option.direction.ordinal()), (App)Codec.LONG.fieldOf("pos").forGetter(option -> option.pos.m_121878_()), (App)Codec.STRING.fieldOf("ammo_id").forGetter(option -> option.ammoId), (App)Codec.STRING.fieldOf("gun_id").forGetter(option -> option.gunId), (App)Codec.STRING.optionalFieldOf("gun_display_id", (Object)DefaultAssets.DEFAULT_GUN_DISPLAY_ID.toString()).forGetter(option -> option.gunDisplayId)).apply((Applicative)builder, BulletHoleOption::new));
    public static final ParticleOptions.Deserializer<BulletHoleOption> DESERIALIZER = new ParticleOptions.Deserializer<BulletHoleOption>(){

        public BulletHoleOption fromCommand(ParticleType<BulletHoleOption> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int dir = reader.readInt();
            reader.expect(' ');
            long pos = reader.readLong();
            reader.expect(' ');
            String ammoId = reader.readString();
            reader.expect(' ');
            String gunId = reader.readString();
            reader.expect(' ');
            String gunDisplayId = reader.readString();
            return new BulletHoleOption(dir, pos, ammoId, gunId, gunDisplayId);
        }

        public BulletHoleOption fromNetwork(ParticleType<BulletHoleOption> particleType, FriendlyByteBuf buffer) {
            return new BulletHoleOption(buffer.m_130242_(), buffer.readLong(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130277_());
        }
    };
    private final Direction direction;
    private final BlockPos pos;
    private final String ammoId;
    private final String gunId;
    private final String gunDisplayId;

    public BulletHoleOption(int dir, long pos, String ammoId, String gunId, String gunDisplayId) {
        this.direction = Direction.values()[dir];
        this.pos = BlockPos.m_122022_((long)pos);
        this.ammoId = ammoId;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
    }

    public BulletHoleOption(Direction dir, BlockPos pos, String ammoId, String gunId, String gunDisplayId) {
        this.direction = dir;
        this.pos = pos;
        this.ammoId = ammoId;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getAmmoId() {
        return this.ammoId;
    }

    public String getGunId() {
        return this.gunId;
    }

    public String getGunDisplayId() {
        return this.gunDisplayId;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticles.BULLET_HOLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.direction);
        buffer.m_130064_(this.pos);
        buffer.m_130070_(this.ammoId);
        buffer.m_130070_(this.gunId);
        buffer.m_130070_(this.gunDisplayId);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()) + " " + this.direction.m_122433_();
    }
}

