/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.event.common.GunShootEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ServerMessageSyncBaseTimestamp;
import com.tacz.guns.network.message.event.ServerMessageGunShoot;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class LivingEntityShoot {
    private final LivingEntity shooter;
    private final ShooterDataHolder data;
    private final LivingEntityDrawGun draw;

    public LivingEntityShoot(LivingEntity shooter, ShooterDataHolder data, LivingEntityDrawGun draw) {
        this.shooter = shooter;
        this.data = data;
        this.draw = draw;
    }

    public ShootResult shoot(Supplier<Float> pitch, Supplier<Float> yaw, long timestamp) {
        boolean noAmmo;
        if (this.data.currentGunItem == null) {
            return ShootResult.NOT_DRAW;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof IGun)) {
            return ShootResult.NOT_GUN;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(gunId);
        if (gunIndexOptional.isEmpty()) {
            return ShootResult.ID_NOT_EXIST;
        }
        CommonGunIndex gunIndex = gunIndexOptional.get();
        if (((Boolean)SyncConfig.SERVER_SHOOT_COOLDOWN_V.get()).booleanValue()) {
            long coolDown = this.getShootCoolDown(timestamp);
            if (coolDown == -1L) {
                return ShootResult.UNKNOWN_FAIL;
            }
            if (coolDown > 0L) {
                return ShootResult.COOL_DOWN;
            }
        }
        if (((Boolean)SyncConfig.SERVER_SHOOT_NETWORK_V.get()).booleanValue()) {
            MinecraftServer server = Objects.requireNonNull(this.shooter.m_20194_());
            double tickTime = Math.max((double)server.f_129748_[server.m_129921_() % 100] * 1.0E-6, 50.0);
            long alpha = System.currentTimeMillis() - this.data.baseTimestamp - timestamp;
            if (alpha < -300L || (double)alpha > 300.0 + tickTime * 2.0) {
                LivingEntity livingEntity = this.shooter;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ServerMessageSyncBaseTimestamp());
                }
                return ShootResult.NETWORK_FAIL;
            }
        }
        if (this.data.reloadStateType.isReloading()) {
            return ShootResult.IS_RELOADING;
        }
        if (this.draw.getDrawCoolDown() != 0L) {
            return ShootResult.IS_DRAWING;
        }
        if (this.data.isBolting) {
            return ShootResult.IS_BOLTING;
        }
        if (this.data.sprintTimeS > 0.0f) {
            return ShootResult.IS_SPRINTING;
        }
        IGunOperator gunOperator = IGunOperator.fromLivingEntity(this.shooter);
        Bolt boltType = gunIndex.getGunData().getBolt();
        boolean useInventoryAmmo = iGun.useInventoryAmmo(currentGunItem);
        boolean hasAmmoInBarrel = iGun.hasBulletInBarrel(currentGunItem) && boltType != Bolt.OPEN_BOLT;
        boolean hasInventoryAmmo = iGun.hasInventoryAmmo(this.shooter, currentGunItem, gunOperator.needCheckAmmo()) || hasAmmoInBarrel;
        int ammoCount = iGun.getCurrentAmmoCount(currentGunItem) + (hasAmmoInBarrel ? 1 : 0);
        boolean bl = noAmmo = useInventoryAmmo && !hasInventoryAmmo || !useInventoryAmmo && ammoCount < 1;
        if (noAmmo) {
            return ShootResult.NO_AMMO;
        }
        if (gunIndex.getGunData().hasHeatData() && iGun.isOverheatLocked(currentGunItem)) {
            return ShootResult.OVERHEATED;
        }
        if (boltType == Bolt.MANUAL_ACTION && !hasAmmoInBarrel) {
            return ShootResult.NEED_BOLT;
        }
        if (boltType == Bolt.CLOSED_BOLT && !hasAmmoInBarrel) {
            if (useInventoryAmmo) {
                this.consumeAmmoFromPlayer(1, currentGunItem, gunOperator.needCheckAmmo());
            } else {
                iGun.reduceCurrentAmmoCount(currentGunItem);
            }
            iGun.setBulletInBarrel(currentGunItem, true);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new GunShootEvent(this.shooter, currentGunItem, LogicalSide.SERVER))) {
            return ShootResult.FORGE_EVENT_CANCEL;
        }
        NetworkHandler.sendToTrackingEntity(new ServerMessageGunShoot(this.shooter.m_19879_(), currentGunItem), (Entity)this.shooter);
        this.data.lastShootTimestamp = this.data.shootTimestamp;
        this.data.heatTimestamp = System.currentTimeMillis();
        this.data.shootTimestamp = timestamp;
        if (iGun instanceof AbstractGunItem) {
            AbstractGunItem logicGun = (AbstractGunItem)iGun;
            logicGun.shoot(this.data, currentGunItem, pitch, yaw, this.shooter);
        }
        return ShootResult.SUCCESS;
    }

    public long getShootCoolDown() {
        return this.getShootCoolDown(System.currentTimeMillis() - this.data.baseTimestamp);
    }

    public long getShootCoolDown(long timestamp) {
        if (this.data.currentGunItem == null) {
            return 0L;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof IGun)) {
            return 0L;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(gunId);
        FireMode fireMode = iGun.getFireMode(currentGunItem);
        long interval = timestamp - this.data.shootTimestamp;
        if (fireMode == FireMode.BURST) {
            return gunIndex.map(index -> {
                long coolDown = (long)(index.getGunData().getBurstData().getMinInterval() * 1000.0) - interval;
                return Math.max(coolDown -= 5L, 0L);
            }).orElse(-1L);
        }
        return gunIndex.map(index -> {
            long coolDown = index.getGunData().getShootInterval(this.shooter, fireMode, currentGunItem) - interval;
            return Math.max(coolDown -= 5L, 0L);
        }).orElse(-1L);
    }

    public void consumeAmmoFromPlayer(int neededAmount, ItemStack itemStack, boolean needCheckAmmo) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem abstractGunItem = (AbstractGunItem)item;
        if (!needCheckAmmo) {
            return;
        }
        if (abstractGunItem.useDummyAmmo(itemStack)) {
            abstractGunItem.findAndExtractDummyAmmo(itemStack, neededAmount);
        } else {
            this.shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> abstractGunItem.findAndExtractInventoryAmmo((IItemHandler)cap, itemStack, neededAmount));
        }
    }
}

