/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client.sound;

import immersive_melodies.Config;
import immersive_melodies.client.sound.NoteSoundInstance;
import immersive_melodies.client.sound.SoundManager;
import immersive_melodies.mixin.MusicTrackerAccessor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class SoundManagerImpl
implements SoundManager {
    private final Minecraft client;
    private final ScheduledExecutorService executor;

    public SoundManagerImpl(Minecraft client) {
        this.client = client;
        this.executor = new ScheduledThreadPoolExecutor(1);
    }

    @Override
    public void playSound(double x, double y, double z, SoundEvent event, SoundSource category, float volume, float pitch, long length, long sustain, long delay, Entity entity) {
        delay = Math.max(0L, delay + (long)Config.getInstance().getBufferDelay);
        this.executor.schedule(() -> {
            NoteSoundInstance positionedSoundInstance = new NoteSoundInstance(event, category, volume, pitch, length, sustain, entity);
            this.client.execute(() -> this.client.m_91106_().m_120367_((SoundInstance)positionedSoundInstance));
        }, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isFirstPerson(Entity entity) {
        return Minecraft.m_91087_().m_91288_() == entity && !Minecraft.m_91087_().f_91063_.m_109153_().m_90594_();
    }

    @Override
    public boolean audible(Entity entity) {
        Entity cameraEntity = Minecraft.m_91087_().m_91288_();
        return cameraEntity != null && cameraEntity.m_20270_(entity) < (float)Config.getInstance().maxAudibleDistance;
    }

    @Override
    public void pauseGameMusic() {
        MusicTrackerAccessor musicTrackerAccessor = (MusicTrackerAccessor)this.client.m_91397_();
        if (musicTrackerAccessor.getCurrent() != null) {
            this.client.m_91397_().m_120186_();
        }
    }
}

