/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.networking.IGridNode;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.menu.guisync.GuiSync;
import appeng.menu.guisync.PacketWritable;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.common.me.wireless.WirelessStatus;
import com.glodblock.github.extendedae.common.tileentities.TileWirelessHub;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.glodium.network.packet.sync.Paras;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;

public class ContainerWirelessHub
extends UpgradeableMenu<TileWirelessHub>
implements IActionHolder {
    public static final MenuType<ContainerWirelessHub> TYPE = MenuTypeBuilder.create(ContainerWirelessHub::new, TileWirelessHub.class).build("wireless_hub");
    @GuiSync(value=7)
    public double powerUse;
    @GuiSync(value=8)
    public int usedChannel;
    @GuiSync(value=9)
    public int maxChannel;
    @GuiSync(value=10)
    public PortStatus status = new PortStatus();
    private final Map<String, Consumer<Paras>> actions = this.createHolder();

    public ContainerWirelessHub(int id, Inventory ip, TileWirelessHub host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        this.actions.put("disconnect", o -> this.disconnect((Integer)o.get(0)));
    }

    private void disconnect(int port) {
        ((TileWirelessHub)this.getHost()).killPort(port);
    }

    public WirelessStatus getStatus(int port) {
        return this.status.getStatus((int)port).status;
    }

    public BlockPos getRemotePosition(int port) {
        return BlockPos.m_122022_((long)this.status.getStatus((int)port).pos);
    }

    public void m_38946_() {
        this.powerUse = ((TileWirelessHub)this.getHost()).getPowerUse();
        IGridNode node = ((TileWirelessHub)this.getHost()).getMainNode().getNode();
        if (node != null) {
            this.usedChannel = node.getUsedChannels();
            this.maxChannel = node.getMaxChannels();
        } else {
            this.usedChannel = 0;
            this.maxChannel = 0;
        }
        PortStatus hostStatus = new PortStatus();
        for (int i = 0; i < 8; ++i) {
            BlockPos otherSide = ((TileWirelessHub)this.getHost()).getOtherSide(i);
            WirelessStatus localStatus = this.status.getStatus((int)i).status;
            long localPos = this.status.getStatus((int)i).pos;
            if (otherSide == null) {
                localPos = 0L;
                localStatus = ((TileWirelessHub)this.getHost()).getFrequency(i) == 0L ? WirelessStatus.UNCONNECTED : WirelessStatus.REMOTE_ERROR;
            } else {
                localPos = otherSide.m_121878_();
                localStatus = WirelessStatus.WORKING;
            }
            if (!((TileWirelessHub)this.getHost()).getMainNode().isPowered() && localStatus == WirelessStatus.WORKING) {
                localStatus = WirelessStatus.NO_POWER;
            }
            hostStatus.setStatus(i, new PortStatus.Status(localPos, localStatus));
        }
        this.status = hostStatus;
        super.m_38946_();
    }

    @NotNull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.actions;
    }

    public record PortStatus(Status[] statuses) implements PacketWritable
    {
        public PortStatus() {
            this(new Status[8]);
            Arrays.fill(this.statuses, new Status(0L, WirelessStatus.UNCONNECTED));
        }

        public PortStatus(FriendlyByteBuf data) {
            this(new Status[8]);
            for (int i = 0; i < 8; ++i) {
                this.statuses[i] = Status.readFromPacket(data);
            }
        }

        private Status getStatus(int port) {
            return this.statuses[port];
        }

        private void setStatus(int port, Status status) {
            this.statuses[port] = status;
        }

        public void writeToPacket(FriendlyByteBuf data) {
            for (int i = 0; i < 8; ++i) {
                this.statuses[i].writeToPacket(data);
            }
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.statuses);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Status[]) {
                Object[] that = (Status[])o;
                return Arrays.equals(this.statuses, that);
            }
            return false;
        }

        private record Status(long pos, WirelessStatus status) implements PacketWritable
        {
            static Status readFromPacket(FriendlyByteBuf data) {
                return new Status(data.readLong(), (WirelessStatus)data.m_130066_(WirelessStatus.class));
            }

            public void writeToPacket(FriendlyByteBuf data) {
                data.writeLong(this.pos);
                data.m_130068_((Enum)this.status);
            }
        }
    }
}

