/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.biome;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.lyof.phantasm.config.ConfigEntries;
import net.lyof.phantasm.world.biome.ModBiomes;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.fml.ModList;

public class EndDataCompat {
    private static final List<Pair<ResourceKey<Biome>, Supplier<Boolean>>> BIOMES = new ArrayList<Pair<ResourceKey<Biome>, Supplier<Boolean>>>();

    public static void register() {
        EndDataCompat.add(ModBiomes.DREAMING_DEN, () -> ConfigEntries.doDreamingDenBiome);
        EndDataCompat.add((ResourceKey<Biome>)Biomes.f_48164_, () -> ConfigEntries.doDreamingDenBiome && ConfigEntries.doAcidburntAbyssesBiome && EndDataCompat.getCompatibilityMode().equals("endercon"));
        EndDataCompat.add(ModBiomes.ACIDBURNT_ABYSSES, () -> ConfigEntries.doAcidburntAbyssesBiome);
    }

    public static String getCompatibilityMode() {
        boolean auto = ConfigEntries.dataCompatMode.equals("automatic");
        if (auto) {
            if (ModList.get().isLoaded("mr_endercon")) {
                return "endercon";
            }
            if (ModList.get().isLoaded("nullscape")) {
                return "nullscape";
            }
            return "default";
        }
        return ConfigEntries.dataCompatMode;
    }

    public static void add(ResourceKey<Biome> biome, Supplier<Boolean> condition) {
        BIOMES.add((Pair<ResourceKey<Biome>, Supplier<Boolean>>)new Pair(biome, condition));
    }

    public static boolean contains(Holder<Biome> biome) {
        return BIOMES.stream().anyMatch(pair -> pair.getFirst() == biome);
    }

    public static List<ResourceKey<Biome>> getEnabledBiomes() {
        ArrayList<ResourceKey<Biome>> result = new ArrayList<ResourceKey<Biome>>();
        for (Pair<ResourceKey<Biome>, Supplier<Boolean>> pair : BIOMES) {
            if (!((Boolean)((Supplier)pair.getSecond()).get()).booleanValue()) continue;
            result.add((ResourceKey<Biome>)((ResourceKey)pair.getFirst()));
        }
        return result;
    }
}

