/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.util.FormattedCharSequence;

public class Constants {
    public static final Ordering<String> CASE_INSENSITIVE_NULL_SAFE_ORDER = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsLast();
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Joiner path = Joiner.on((String)File.separator).useForNull("");
    private static final String END = null;
    public static String JOURNEYMAP_DIR = "journeymap";
    public static String CONFIG_DIR_LEGACY = path.join((Object)JOURNEYMAP_DIR, (Object)"config", new Object[0]);
    public static String CONFIG_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"config", new Object[]{Journeymap.JM_VERSION.toMajorMinorString(), END});
    public static String DATA_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"data", new Object[0]);
    public static String SP_DATA_DIR = path.join((Object)DATA_DIR, (Object)WorldType.sp, new Object[]{END});
    public static String MP_DATA_DIR = path.join((Object)DATA_DIR, (Object)WorldType.mp, new Object[]{END});
    public static String RESOURCE_PACKS_DEFAULT = "Default";
    private static String ICON_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"icon", new Object[0]);
    public static String WEB_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"web", new Object[0]);
    public static String ENTITY_ICON_DIR = path.join((Object)ICON_DIR, (Object)"entity", new Object[]{END});
    public static String WAYPOINT_ICON_DIR = path.join((Object)ICON_DIR, (Object)"waypoint", new Object[]{END});
    public static String THEME_ICON_DIR = path.join((Object)ICON_DIR, (Object)"theme", new Object[]{END});

    public static Locale getLocale() {
        Locale locale = Locale.getDefault();
        try {
            String lang = Minecraft.m_91087_().m_91102_().m_264236_();
            locale = new Locale(lang);
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't determine locale from game settings, defaulting to " + locale);
        }
        return locale;
    }

    public static String getString(String key) {
        if (Minecraft.m_91087_() == null) {
            return key;
        }
        try {
            String result = Constants.getTranslatedTextComponent(key).getString();
            if (!result.equals(key) || JourneymapClient.getInstance().isMapping().booleanValue()) {
                // empty if block
            }
            return result;
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn(String.format("Message key '%s' threw exception: %s", key, t.getMessage()));
            return key;
        }
    }

    public static MutableComponent getStringTextComponent(String key) {
        return Component.m_237113_((String)key);
    }

    public static MutableComponent getTranslatedTextComponent(String key) {
        return Component.m_237115_((String)key);
    }

    public static FormattedCharSequence getFormattedText(String text, Style style, Font fontRenderer, int size) {
        MutableComponent textComponent = Constants.getStringTextComponent(text);
        List toolTipList = Language.m_128107_().m_128112_(fontRenderer.m_92865_().m_92414_((FormattedText)textComponent, size, style));
        return FormattedCharSequence.m_13722_((List)toolTipList);
    }

    public static String getString(String key, Object ... params) {
        if (Minecraft.m_91087_() == null) {
            return String.format("%s (%s)", key, Joiner.on((String)",").join(params));
        }
        try {
            String result = I18n.m_118938_((String)key, (Object[])params);
            if (result.equals(key) && JourneymapClient.getInstance().isMapping().booleanValue()) {
                Journeymap.getLogger().warn("Message key not found: " + String.format("%s (%s)", key, Joiner.on((String)",").join(params)));
            }
            return result;
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn(String.format("Message key '%s' threw exception: %s", key, t.getMessage()));
            return key;
        }
    }

    public static boolean safeEqual(String first, String second) {
        int result = CASE_INSENSITIVE_NULL_SAFE_ORDER.compare((Object)first, (Object)second);
        if (result != 0) {
            return false;
        }
        return CASE_INSENSITIVE_NULL_SAFE_ORDER.compare((Object)first, (Object)second) == 0;
    }

    public static PackRepository getResourcePacks() {
        PackRepository resourcepackrepository = null;
        try {
            resourcepackrepository = Minecraft.m_91087_().m_91099_();
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Can't get resource pack names: %s", LogFormatter.toString(t)));
        }
        return resourcepackrepository;
    }

    public static String birthdayMessage() {
        Calendar today = Calendar.getInstance();
        int month = today.get(2);
        int date = today.get(5);
        if (month == 6 && date == 2) {
            return Constants.getString("jm.common.birthday", "techbrew");
        }
        if (month == 8 && date == 21) {
            return Constants.getString("jm.common.birthday", "mysticdrew");
        }
        return null;
    }

    public static enum WorldType {
        mp,
        sp;

    }
}

