/*
 * Decompiled with CFR 0.152.
 */
package com.entropy.tacz_turrets.common.entity;

import com.entropy.tacz_turrets.common.entity.TurretEntity;
import com.mojang.datafixers.util.Pair;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.item.ModernKineticGunItem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaczShootAttack<E extends TurretEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT)});
    protected float attackRadius;
    @Nullable
    protected LivingEntity target = null;

    public List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public TaczShootAttack(int attackRadius) {
        this.attackRadius = attackRadius;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull E entity) {
        this.target = BrainUtils.getTargetOfEntity(entity);
        return this.target != null && BrainUtils.canSee(entity, (LivingEntity)this.target) && this.target.m_20148_() != ((TurretEntity)((Object)entity)).owner;
    }

    protected void start(E entity) {
        if (this.target != null && entity.m_5448_() != null && BehaviorUtils.m_22636_((Brain)entity.m_6274_(), (LivingEntity)entity.m_5448_())) {
            entity.m_7618_(EntityAnchorArgument.Anchor.EYES, entity.m_5448_().m_20318_(1.0f));
            BehaviorUtils.m_22595_(entity, (LivingEntity)entity.m_5448_());
            if (entity.m_142582_((Entity)entity.m_5448_()) && entity.m_21205_().m_41720_() instanceof ModernKineticGunItem) {
                ((TurretEntity)((Object)entity)).aim(true);
                ShootResult result = ((TurretEntity)((Object)entity)).shoot(() -> Float.valueOf(entity.m_5686_(1.0f)), () -> Float.valueOf(entity.m_5675_(1.0f)));
                switch (result) {
                    case SUCCESS: {
                        ((TurretEntity)((Object)entity)).firing = true;
                        ++((TurretEntity)((Object)entity)).collectiveShots;
                        ((TurretEntity)((Object)entity)).rangedCooldown = ((TurretEntity)((Object)entity)).getStateRangedCooldown();
                        break;
                    }
                    case NEED_BOLT: {
                        ((TurretEntity)((Object)entity)).bolt();
                        break;
                    }
                    case NO_AMMO: {
                        ((TurretEntity)((Object)entity)).reload();
                    }
                }
            }
        }
    }

    protected void stop(E entity) {
    }

    protected void tick(E entity) {
        super.tick(entity);
    }
}

