/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.arsdelight.init.data;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ADModConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
    }

    public static class Client {
        Client(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enableThirstCompat;
        public final ForgeConfigSpec.DoubleValue maxShieldingAbsorption;
        public final ForgeConfigSpec.DoubleValue wildenSpellDamageBonus;
        public final ForgeConfigSpec.DoubleValue wildenMaxManaBonus;
        public final ForgeConfigSpec.DoubleValue wildenManaRegenBonus;
        public final ForgeConfigSpec.BooleanValue drygmyFarmingToolPlainCopy;
        public final ForgeConfigSpec.IntValue drygmyFarmingDamageTool;

        Common(ForgeConfigSpec.Builder builder) {
            this.enableThirstCompat = builder.define("enableThirstCompat", true);
            this.maxShieldingAbsorption = builder.comment("Max absorption allowed for Shielding I effect. Every level doubles the cap").defineInRange("maxShieldingAbsorption", 8.0, 2.0, 100.0);
            this.wildenSpellDamageBonus = builder.comment("Wilden effect: spell damage bonus per level").defineInRange("wildenSpellDamageBonus", 0.2, 0.0, 1.0);
            this.wildenMaxManaBonus = builder.comment("Wilden effect: max mana bonus per level").defineInRange("wildenMaxManaBonus", 0.2, 0.0, 1.0);
            this.wildenManaRegenBonus = builder.comment("Wilden effect: mana regen bonus per level").defineInRange("wildenManaRegenBonus", 0.2, 0.0, 1.0);
            this.drygmyFarmingToolPlainCopy = builder.comment("Drygmy farming: make a plain copy of the tool to prevent enchantments, affixes, and gems from taking effect").define("drygmyFarmingToolPlainCopy", false);
            this.drygmyFarmingDamageTool = builder.comment("Drygmy farming: cost durability on the tool used for farming").defineInRange("drygmyFarmingDamageTool", 2, 0, 10000);
        }
    }
}

