/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.network.packets.mod;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.addy4ever.nivarion.ModConfig;
import net.addy4ever.nivarion.anticheat.client.AntiCheatClient;
import net.addy4ever.nivarion.anticheat.client.packets.CaughtModsPacket;
import net.addy4ever.nivarion.anticheat.mods.ModCheck;
import net.addy4ever.nivarion.network.PacketHandler;
import net.addy4ever.nivarion.network.packets.mod.RespondModListPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ModListPacket {
    private final List<String> hashList;
    private final List<String> raw;

    public ModListPacket(List<String> hashList, List<String> raw) {
        this.hashList = hashList;
        this.raw = raw;
    }

    public static void encode(ModListPacket msg, ByteBuf buf) {
        int i;
        FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(buf);
        friendlyByteBuf.m_130130_(msg.hashList.size());
        for (i = 0; i < msg.hashList.size(); ++i) {
            friendlyByteBuf.m_130070_(msg.hashList.get(i));
        }
        friendlyByteBuf.m_130130_(msg.raw.size());
        for (i = 0; i < msg.raw.size(); ++i) {
            friendlyByteBuf.m_130070_(msg.raw.get(i));
        }
    }

    public static ModListPacket decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        if (size < 0) {
            return new ModListPacket(null, null);
        }
        ArrayList<String> hashList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            hashList.add(buf.m_130277_());
        }
        size = buf.m_130242_();
        if (size < 0) {
            return new ModListPacket(null, null);
        }
        ArrayList<String> raw = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            raw.add(buf.m_130277_());
        }
        return new ModListPacket(hashList, raw);
    }

    public static void handle(ModListPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender != null && !sender.m_9232_()) {
                ModCheck.remove(sender.m_20148_());
                ArrayList<String> unwanted = new ArrayList<String>();
                List whitelistedMods = (List)ModConfig.MD5_HASH_LIST.get();
                for (String string : msg.hashList) {
                    if (whitelistedMods.contains(string)) continue;
                    unwanted.add(string);
                }
                if (!unwanted.isEmpty()) {
                    ArrayList<String> output = new ArrayList<String>(unwanted.size() + 2 + msg.raw.size());
                    output.add("Unerw\u00fcnschte Mods:");
                    for (String str : unwanted) {
                        for (String str2 : msg.raw) {
                            if (!str2.contains(str)) continue;
                            output.add(str2);
                        }
                    }
                    output.add("");
                    output.addAll(msg.raw);
                    output.forEach(System.out::println);
                    AntiCheatClient.getInstance().sendPacket(new CaughtModsPacket(output, sender.m_7755_().getString(), sender.m_20148_()));
                    RespondModListPacket respondModListPacket = new RespondModListPacket(false);
                    PacketHandler.sendToClient(respondModListPacket, sender);
                    sender.f_8906_.m_9942_((Component)Component.m_237113_((String)"Additional mods detected that are not whitelisted. Please remove them immediately."));
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

