/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.network.packets.mod;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.addy4ever.nivarion.anticheat.client.AntiCheatClient;
import net.addy4ever.nivarion.anticheat.client.packets.CaughtXRayPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class IGotCaughtPacket {
    private final String message;
    private final int reason;
    private final String name;
    private final UUID uuid;
    private Object additionalData;

    public IGotCaughtPacket(String message, int reason, Object additionalData, String name, UUID uuid) {
        this.message = message;
        this.reason = reason;
        this.name = name;
        this.uuid = uuid;
        this.additionalData = additionalData;
    }

    public static void encode(IGotCaughtPacket msg, ByteBuf buf) {
        FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(buf);
        friendlyByteBuf.m_130070_(msg.message);
        friendlyByteBuf.m_130130_(msg.reason);
        friendlyByteBuf.m_130070_(msg.name);
        friendlyByteBuf.m_130077_(msg.uuid);
        if (msg.reason == 0) {
            List list = (List)msg.additionalData;
            friendlyByteBuf.m_130130_(list.size());
            for (String s : list) {
                friendlyByteBuf.m_130070_(s);
            }
        }
    }

    public static IGotCaughtPacket decode(FriendlyByteBuf buf) {
        String message = buf.m_130277_();
        int reason = buf.m_130242_();
        String name = buf.m_130277_();
        UUID uuid = buf.m_130259_();
        ArrayList<String> data = null;
        if (reason == 0) {
            int len = buf.m_130242_();
            ArrayList<String> list = new ArrayList<String>(len);
            for (int i = 0; i < len; ++i) {
                list.add(buf.m_130277_());
            }
            data = list;
        }
        return new IGotCaughtPacket(message, reason, data, name, uuid);
    }

    public static void handle(IGotCaughtPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender != null && msg.reason == 0) {
                AntiCheatClient.getInstance().sendPacket(new CaughtXRayPacket((List)msg.additionalData, msg.name, msg.uuid));
            }
        });
        ctx.setPacketHandled(true);
    }
}

