/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.network.packets.crates;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.addy4ever.nivarion.crates.CrateItem;
import net.addy4ever.nivarion.crates.CrateItemRarity;
import net.addy4ever.nivarion.crates.CrateRewardMap;
import net.addy4ever.nivarion.network.CrateAnimationHolder;
import net.addy4ever.nivarion.network.PacketHandler;
import net.addy4ever.nivarion.network.packets.crates.StartCrateAnimationPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class OpenCrateRequestPacket {
    private static final CrateRewardMap CRATE_REWARD_MAP = new CrateRewardMap();

    public static void encode(OpenCrateRequestPacket msg, ByteBuf buf) {
    }

    public static OpenCrateRequestPacket decode(FriendlyByteBuf buf) {
        return new OpenCrateRequestPacket();
    }

    public static void handle(OpenCrateRequestPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender != null) {
                CrateItem awardedItem = OpenCrateRequestPacket.chooseRandomItemBasedOnProbabilitiesServerSide();
                CrateAnimationHolder.cache((Player)sender, awardedItem);
                PacketHandler.sendToClient(new StartCrateAnimationPacket(awardedItem, CRATE_REWARD_MAP.toList()), sender);
            }
        });
        ctx.setPacketHandled(true);
    }

    private static CrateItem chooseRandomItemBasedOnProbabilitiesServerSide() {
        return CRATE_REWARD_MAP.selectRandom();
    }

    static {
        CRATE_REWARD_MAP.insert(CrateItemRarity.NORMAL, new ItemStack((ItemLike)Items.f_42329_));
        CRATE_REWARD_MAP.insert(CrateItemRarity.RARE, new ItemStack((ItemLike)Items.f_41905_));
        CRATE_REWARD_MAP.insert(CrateItemRarity.EPIC, new ItemStack((ItemLike)Items.f_42415_));
        CRATE_REWARD_MAP.insert(CrateItemRarity.LEGENDARY, new ItemStack((ItemLike)Items.f_42616_));
        CRATE_REWARD_MAP.insert(CrateItemRarity.MYTHIC, new ItemStack((ItemLike)Items.f_42418_));
    }
}

