/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.crates;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.addy4ever.nivarion.crates.CrateItem;
import net.addy4ever.nivarion.crates.CrateItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CrateRewardMap {
    private final HashMap<CrateItemRarity, List<ItemStack>> map = new HashMap();
    private final Random random = new SecureRandom();
    private int size = 0;

    public CrateRewardMap() {
        for (CrateItemRarity rarity : CrateItemRarity.values()) {
            this.map.put(rarity, new ArrayList());
        }
    }

    public void insert(@NotNull CrateItemRarity rarity, @NotNull ItemStack itemStack) {
        List items = this.map.getOrDefault((Object)rarity, new ArrayList());
        items.add(itemStack);
        this.map.put(rarity, items);
        ++this.size;
    }

    public CrateItem getRandom(@NotNull CrateItemRarity rarity) {
        List items = this.map.getOrDefault((Object)rarity, new ArrayList());
        int size = items.size();
        if (size <= 0) {
            return null;
        }
        return new CrateItem((ItemStack)items.get(this.random.nextInt(size)), rarity);
    }

    public CrateItem selectRandom() {
        float random = this.random.nextFloat();
        CrateItemRarity[] rarities = CrateItemRarity.values();
        for (int i = rarities.length - 1; i >= 0; --i) {
            CrateItem crateItem;
            if (!(random <= rarities[i].rarity) || (crateItem = this.getRandom(rarities[i])) == null) continue;
            return crateItem;
        }
        return new CrateItem(new ItemStack((ItemLike)Items.f_41852_), CrateItemRarity.NORMAL);
    }

    public List<CrateItem> toList() {
        int size = 0;
        for (CrateItemRarity rarity : CrateItemRarity.values()) {
            size += ((List)this.map.getOrDefault((Object)rarity, new ArrayList())).size();
        }
        ArrayList<CrateItem> list = new ArrayList<CrateItem>(size);
        for (CrateItemRarity rarity : CrateItemRarity.values()) {
            ((List)this.map.getOrDefault((Object)rarity, new ArrayList())).stream().map(itemStack -> new CrateItem((ItemStack)itemStack, rarity)).forEach(list::add);
        }
        return list;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }
}

