/*
 * Decompiled with CFR 0.152.
 */
package net.addy4ever.nivarion.crates;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.addy4ever.nivarion.crates.CrateItem;
import net.addy4ever.nivarion.crates.CrateItemRarity;
import net.addy4ever.nivarion.crates.CrateRewardMap;
import net.addy4ever.nivarion.network.PacketHandler;
import net.addy4ever.nivarion.network.packets.crates.FinishCrateAnimationPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CrateOpeningScreen
extends Screen {
    private final CrateRewardMap possibleRewards;
    private final Random random = new Random();
    private boolean animationStarted = false;
    private boolean animationFinished = false;
    private boolean decelerationStarted = false;
    private final CrateItem finalSelectedItem;
    private final List<CrateItem> scrollingItems = new ArrayList<CrateItem>();
    private float scrollPosition = 0.0f;
    private float scrollSpeed = 0.0f;
    private final float INITIAL_SCROLL_SPEED = 25.0f;
    private float calculatedDecelerationRate = 0.0f;
    private final int ITEM_DISPLAY_WIDTH = 32;
    private final int ITEM_DISPLAY_HEIGHT = 32;
    private final int NUM_VISIBLE_ITEMS = 9;
    private float targetScrollPosition = 0.0f;
    private int finalItemPlacedIndex;
    private final int DECELERATION_ITEM_DISTANCE = 20;
    private float decelerationTriggerPosition = 0.0f;
    private boolean hasBeenInitialized = false;
    private int scissorX;
    private int scissorY;
    private int scissorWidth;
    private int scissorHeight;
    private int lastVisibleItemIndex = 0;

    public CrateOpeningScreen(@NotNull CrateItem reward, @NotNull List<CrateItem> possibleItems) {
        super((Component)Component.m_237113_((String)"Crate Opening"));
        this.finalSelectedItem = reward;
        this.possibleRewards = new CrateRewardMap();
        possibleItems.forEach(crateItem -> this.possibleRewards.insert(crateItem.getRarity(), crateItem.getReward()));
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!this.hasBeenInitialized) {
            this.animationStarted = true;
            this.scrollSpeed = 25.0f;
            this.decelerationStarted = false;
            this.animationFinished = false;
            this.scrollPosition = 0.0f;
            this.scrollingItems.clear();
            int numberOfScrollingItems = 20 + this.random.nextInt(26);
            int minRequiredItems = 34;
            numberOfScrollingItems = Math.max(numberOfScrollingItems, minRequiredItems);
            for (int i = 0; i < numberOfScrollingItems; ++i) {
                this.scrollingItems.add(this.getRandomWeightedItem());
            }
            this.finalItemPlacedIndex = this.scrollingItems.size() - 1 - 4;
            if (this.finalItemPlacedIndex < 20) {
                this.finalItemPlacedIndex = 20;
            }
            if (this.finalItemPlacedIndex >= this.scrollingItems.size()) {
                this.finalItemPlacedIndex = this.scrollingItems.size() - 1;
            }
            this.scrollingItems.set(this.finalItemPlacedIndex, this.finalSelectedItem);
            this.targetScrollPosition = (float)this.finalItemPlacedIndex * 32.0f - 144.0f + 16.0f;
            this.decelerationTriggerPosition = this.targetScrollPosition - 640.0f;
            this.hasBeenInitialized = true;
        }
        this.updateScissorDimensions();
    }

    public void m_6574_(@NotNull Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        this.updateScissorDimensions();
    }

    private void updateScissorDimensions() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.scissorX = centerX - 144 - 8;
        this.scissorY = centerY - 16 + 8 - 8;
        this.scissorWidth = 304;
        this.scissorHeight = 48;
    }

    public void m_86600_() {
        super.m_86600_();
        if (!this.animationFinished) {
            if (!this.decelerationStarted && this.scrollPosition >= this.decelerationTriggerPosition) {
                this.decelerationStarted = true;
                float distanceToStop = this.targetScrollPosition - this.scrollPosition;
                if (distanceToStop <= 0.0f) {
                    this.scrollSpeed = 0.0f;
                    this.scrollPosition = this.targetScrollPosition;
                    this.stopAnimation();
                    return;
                }
                this.calculatedDecelerationRate = 625.0f / (2.0f * distanceToStop);
                if (Float.isInfinite(this.calculatedDecelerationRate) || Float.isNaN(this.calculatedDecelerationRate) || this.calculatedDecelerationRate < 0.001f) {
                    this.calculatedDecelerationRate = 0.5f;
                }
            }
            if (this.decelerationStarted) {
                this.scrollSpeed -= this.calculatedDecelerationRate;
                if (this.scrollSpeed < 0.0f) {
                    this.scrollSpeed = 0.0f;
                    this.stopAnimation();
                }
            } else {
                this.scrollSpeed = 25.0f;
            }
            this.scrollPosition += this.scrollSpeed;
            if (this.scrollSpeed <= 0.01f && this.scrollPosition >= this.targetScrollPosition) {
                this.scrollPosition = this.targetScrollPosition;
                this.stopAnimation();
            }
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        if (this.animationStarted && !this.animationFinished) {
            float currentScrollRenderPosition = this.scrollPosition + this.scrollSpeed * partialTicks;
            guiGraphics.m_280168_().m_85836_();
            int windowX = centerX - 144;
            int windowY = centerY - 16 + 8;
            int windowWidth = 288;
            guiGraphics.m_280588_(this.scissorX, this.scissorY, this.scissorX + this.scissorWidth, this.scissorY + this.scissorHeight);
            int firstVisibleItemIndex = (int)(currentScrollRenderPosition / 32.0f) - 1;
            int lastVisibleItemIndex = firstVisibleItemIndex + 9 + 2;
            for (int i = firstVisibleItemIndex; i <= lastVisibleItemIndex; ++i) {
                if (i < 0 || i >= this.scrollingItems.size()) continue;
                CrateItem item = this.scrollingItems.get(i);
                float itemRenderX = (float)(i * 32) - currentScrollRenderPosition + (float)windowX - 4.0f;
                if (!(itemRenderX < (float)(windowX + windowWidth + 32)) || !(itemRenderX + 32.0f > (float)(windowX - 32))) continue;
                int offset = 8;
                guiGraphics.m_280509_((int)itemRenderX - 8, windowY - 8, (int)itemRenderX + 16 + 8, windowY + 16 + 8, FastColor.ARGB32.m_13660_((int)100, (int)item.getRarity().r, (int)item.getRarity().g, (int)item.getRarity().b));
                guiGraphics.m_280480_(item.getReward(), (int)itemRenderX, windowY);
            }
            guiGraphics.m_280618_();
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280509_(centerX - 2, centerY - 16 - 5, centerX + 2, centerY + 16 + 5, -65536);
            if (this.lastVisibleItemIndex != firstVisibleItemIndex) {
                this.lastVisibleItemIndex = firstVisibleItemIndex;
                SimpleSoundInstance soundInstance = SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)(0.9f + Math.abs(this.random.nextFloat(0.1f))));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)soundInstance);
            }
        } else if (this.animationFinished) {
            guiGraphics.m_280480_(this.finalSelectedItem.getReward(), centerX - 8, centerY - 16);
            guiGraphics.m_280653_(this.f_96547_, this.finalSelectedItem.getReward().m_41611_(), centerX, centerY + 10, 0xFFFFFF);
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"Click to close"), centerX, centerY + 20, 0xFFFFFF);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.animationFinished) {
            this.m_7379_();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        if (!this.animationFinished) {
            this.stopAnimation();
        }
        super.m_7379_();
    }

    private CrateItem getRandomWeightedItem() {
        if (this.possibleRewards.isEmpty()) {
            return new CrateItem(new ItemStack((ItemLike)Items.f_42127_), CrateItemRarity.NORMAL);
        }
        return this.possibleRewards.selectRandom();
    }

    private void stopAnimation() {
        this.animationFinished = true;
        PacketHandler.sendToServer(new FinishCrateAnimationPacket());
        SimpleSoundInstance soundInstance = SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12275_, (float)1.0f);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)soundInstance);
    }
}

